Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/lsof
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name hitch
%define version 1.8.0
# Checks may only be ran from a host with internet connection
%global runcheck	0

%global hitch_user	hitch
%global hitch_group	hitch
%global hitch_homedir	%{_sharedstatedir}/hitch
%global hitch_confdir	%{_sysconfdir}/hitch
%global hitch_datadir	%{_datadir}/hitch
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

# A bug in the rhel7 builders? Looks like they set _pkgdocdir fedora style
# without version...?
%if 0%{?rhel} == 7
%global _pkgdocdir %{_docdir}/%{name}-%{version}
%endif

%global _hardened_build 1

Name:		hitch
Version:	1.8.0
Release:	alt1_3
Summary:	Network proxy that terminates TLS/SSL connections

License:	BSD
URL:		https://hitch-tls.org/
Source0:	https://hitch-tls.org/source/%{name}-%{version}%{?v_rc}.tar.gz

BuildRequires:	libev-devel
BuildRequires:	libssl-devel
BuildRequires:	openssl
BuildRequires:	libtool
#BuildRequires:	python-docutils >= 0.6
Requires:	openssl

Patch0:		hitch.systemd.service.patch
Patch1:		hitch.initrc.redhat.patch

BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Source44: import.info

%description
hitch is a network proxy that terminates TLS/SSL connections and forwards the
unencrypted traffic to some backend. It is designed to handle 10s of thousands
of connections efficiently on multicore machines.

%prep
%setup -q -n %{name}-%{version}%{?v_rc}
%patch0
%patch1

%build
#./bootstrap

#export CFLAGS

# manpages are prebuilt, no need to build again
export RST2MAN=/bin/true

%configure --docdir=%_docdir/%{name}

%make_build


%install
%makeinstall_std
sed   '
	s/user = .*/user = "%{hitch_user}"/g;
	s/group = .*/group = "%{hitch_group}"/g;
	s/backend = "\[127.0.0.1\]:8000"/backend = "[127.0.0.1]:6081"/g;
	s/workers = ..../workers = auto/;
	$a\syslog = on
	$a\log-level = 1
	$a\# Add pem files to this directory
	$a\pem-dir = "/etc/pki/tls/private"
	' hitch.conf.example > hitch.conf

%if 0%{?fedora} 
	sed -i 's/^ciphers =.*/ciphers = "PROFILE=SYSTEM"/g' hitch.conf
%endif

rm -f %{buildroot}%{_datarootdir}/doc/%{name}/hitch.conf.example

install -p -D -m 0644 hitch.conf %{buildroot}%{_sysconfdir}/hitch/hitch.conf
install -d -m 0755 %{buildroot}%{hitch_homedir}
install -d -m 0755 %{buildroot}%{hitch_datadir}
install -p -D -m 0644 hitch.service %{buildroot}%{_unitdir}/hitch.service
install -p -D -m 0644 limit.conf    %{buildroot}%{_sysconfdir}/systemd/system/%{name}.service.d/limit.conf
for rpm404_ghost in /run/%{name}/%{name}.pid
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


# check is not enabled by default, as it won't work on the koji builders, 
# nor on machines that can't reach the Internet. 
%check
%if 0%{?runcheck} == 1
make check
%endif

%pre
groupadd -r %{hitch_group} &>/dev/null ||:
useradd -r -g %{hitch_group} -s /sbin/nologin -d %{hitch_homedir} %{hitch_user} &>/dev/null ||:


%post
%post_service hitch
%preun
%preun_service hitch
%files
%doc README.md
%doc CHANGES.rst
%doc hitch.conf.example
%doc docs/*
%doc --no-dereference LICENSE
%{_sbindir}/%{name}
%{_mandir}/man5/%{name}.conf.5*
%{_mandir}/man8/%{name}.8*
%dir %{_sysconfdir}/%{name}
%attr(0700,%hitch_user,%hitch_user) %dir %hitch_homedir
%config(noreplace) %{_sysconfdir}/%{name}/%{name}.conf
%{_unitdir}/%{name}.service
%config(noreplace) %{_sysconfdir}/systemd/system/%{name}.service.d/limit.conf
%ghost %verify(not md5 size mtime)  /run/%{name}/%{name}.pid

%changelog
