Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3 rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: boost-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%undefine __cmake_in_source_build
%global commit b87a88aa66853d3c9d901d4e6be729c5fe69aae0
%global shortcommit %(c=%{commit}; echo ${c:0:7})
%global soversion 3

Name:           hokuyoaist
Version:        3.0.2
Release:        alt9_51
Summary:        Hokuyo Laser SCIP driver

License:        LGPLv3
URL:            https://github.com/gbiggs/hokuyoaist
Source0:        https://github.com/gbiggs/%{name}/archive/%{commit}/%{name}-%{commit}.tar.gz
Patch0:         %{name}-3.0.2-fedora.patch
Patch1:         %{name}-3.0.2-const.patch
Patch2:         0c9870d-fix-boost-lib.patch
Patch3:         51d99dbc-python3-support.patch
Patch4:         %{name}-3.0.2-boostpython.patch

BuildRequires:  gcc-c++
BuildRequires:  boost-complete
BuildRequires:  ctest cmake
BuildRequires:  doxygen
BuildRequires:  flexiport-devel
BuildRequires:  graphviz libgraphviz
BuildRequires:  python3-devel
BuildRequires:  python3-module-sphinx python3-module-sphinx-sphinx-build-symlink

# Older gearbox versions include the hokuyo_aist library, but the hokuyo 
# library in gearbox 10.11 was relicensed to EPL.  This package conflcts 
# with gearbox versions that included the hokuyo_aist support (9.11), 
# but can be installed in parallel with gearbox version 10.11 (which
# is built without hokuyo_aist support)
Conflicts:      gearbox < 10.11
Source44: import.info

%description
This library provides a driver for Hokuyo laser scanner devices using the 
SCIP protocol version 1 or 2. It has been tested with the Hokuyo URG-04LX, 
UBG-04LX, UHG-08LX, UTM-30LX and UXM-30LX-E but it should work with any 
scanner that conforms to these protocol versions, including the URG-04LX-F01 
and the URG-04LX-UG01 (Simple-URG).

%package devel
Group: Other
Summary: Header files and libraries for %{name}
Requires: %{name} = %{version}-%{release}

%description devel
Development libraries and header files for %{name}

%package -n python3-module-hokuyoaist
Group: Other
%{?python_provide:%python_provide python3-%{name}}
Summary: Python bindings for %{name}
Requires: %{name} = %{version}-%{release}

%description -n python3-module-hokuyoaist
Python bindings for %{name}

%prep
%setup -qn %{name}-%{commit}
%patch0 -p0 -b .fedora
%patch1 -p1 -b .const
%patch2 -p1
%patch3 -p1
%patch4 -p0 -b .boostpython
# Fix the library and pkgconfig install paths.
#sed -i 's/\"lib\"/\"%{_lib}\"/' CMakeLists.txt 
# The "breathe" module is not available, so don't use it
sed -i 's/extensions/#extensions/' doc/conf.py.in
# Correct the project version in the CMakeLists.txt
sed -i 's/3.0.1/3.0.2/' CMakeLists.txt

%build
%{fedora_v2_cmake} -DBUILD_EXAMPLES=OFF -DBOOST_LIB_SUFFIX="" -DCMAKE_BUILD_TYPE=Release
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

# Get rid of hidden junk doxygen generates, and remove the installed
# documentation so we can install it with the doc macro
rm -rf %{_vpath_builddir}/doc/html/.buildinfo
rm -rf %{_vpath_builddir}/doc/html/.doctrees
rm -rf %{buildroot}%{_docdir}/%{name}-3

%files
%doc COPYING COPYING.LESSER
%{_libdir}/*.so.%{version}
%{_libdir}/*.so.%{soversion}

%files devel
%doc %{_vpath_builddir}/doc/html
%{_datadir}/%{name}-3
%{_includedir}/%{name}-3
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc
%{_libdir}/%{name}

%files -n python3-module-hokuyoaist
%{python3_sitelibdir}/*.so

%changelog
