# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libcfitsio-devel perl(Devel/Peek.pm) perl-devel perl-podlators
# END SourceDeps(oneline)
BuildRequires: chrpath
Name:           hpic
Version:        0.53.1
Release:        alt3_2
Summary:        Healpix manipulation binaries and library

Group:          Development/C
License:        GPLv2+
URL:            http://cmb.phys.cwru.edu/hpic/
Source0:        http://cmb.phys.cwru.edu/hpic/hpic-%{version}.tar.gz

BuildRequires:  cfitsio-devel
Source44: import.info

%description
hpic is a C and C++ implementation of the healpix pixelization of a sphere 
algorithms.  It includes several command line utilities for reading, writing,
and manipulating healpix files, as well as a library so other programs can
do the same.

%package devel
Group:  Development/C
Summary: Headers required when building programs against hpic
Requires: %{name} = %{version}-%{release}

%description devel
Headers required when building a program against the hpic library,
as well as a static library.

%prep
%setup -q


%build
%configure --disable-dependency-tracking --with-extra-includes=-I%{_includedir}/cfitsio
make %{?_smp_mflags}


%install
mkdir -p %{buildroot}
make DESTDIR=%{buildroot} SUID_ROOT="" install

#Remove files we don't want packaged (BZ# 556055)
rm -f %{buildroot}/%{_libdir}/libhpic.la
rm -f %{buildroot}/%{_libdir}/libhpic.a
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111`; do
	chrpath -d $i ||:
done

%files
%doc README NEWS COPYING AUTHORS ChangeLog doc/hpic.pdf
%{_libdir}/libhpic.so.*
%{_bindir}/hpic*

%files devel
%{_libdir}/libhpic.so
%{_includedir}/hpic.h

%changelog
