# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define srcname herqq

Name:           hupnp
Summary:        Qt string template engine based on the Django template system
Group:          System/Libraries
Version:        1.0.0
Release:        alt1_12
License:        LGPLv3+
URL:            http://www.herqq.org
Source0:        https://downloads.sourceforge.net/project/%{name}/%{name}/%{srcname}-%{version}.zip
Patch0:         herqq-1.0.0-c++11.patch
BuildRequires:  qt4-devel
Source44: import.info


%description
Herqq UPnP (HUPnP) is a software library for building UPnP devices and control 
points conforming to the UPnP Device Architecture version 1.1. It is designed 
to be simple to use and robust in operation. It is built using C++ and the Qt 
Framework following many of the design principles and programming practices 
used in the Qt Framework. It integrates into Qt-based software smoothly and 
enables truly rapid UPnP development.

%files

#--------------------------------------------------------------------

%define hupnp_major 1
%define libhupnp libhupnp%{hupnp_major}

%package -n     %{libhupnp}
Summary:        Library for %{name}
Group:          System/Libraries

%description -n %{libhupnp}
Software library for building UPnP devices and control points.

%files -n %{libhupnp}
%{_libdir}/libHUpnp.so.%{hupnp_major}
%{_libdir}/libHUpnp.so.%{hupnp_major}.*

#--------------------------------------------------------------------

%define qtsolution_major 1
%define qtsolution_api 2.7
%define libqtsolution libqtsolutions_soap%{qtsolution_api}_%{qtsolution_major}

%package -n     %{libqtsolution}
Summary:        Library for %{name}
Group:          System/Libraries
Obsoletes:      %{_lib}libqtsolution1 < 1.0.0-4

%description -n %{libqtsolution}
Library for %{name}.

%files -n %{libqtsolution}
%{_libdir}/libQtSolutions_SOAP-%{qtsolution_api}.so.%{qtsolution_major}
%{_libdir}/libQtSolutions_SOAP-%{qtsolution_api}.so.%{qtsolution_major}.*

#--------------------------------------------------------------------

%package devel
Summary:        Development files for %{name}
Group:          Development/C++
Requires:       %{libqtsolution} = %{version}-%{release}
Requires:       %{libhupnp} = %{version}-%{release}

%description devel
Libraries and header files to develop applications that use %{name}.

%files devel
%{_includedir}/HUpnpCore/
%{_libdir}/libQtSolutions_SOAP-2.7.so
%{_libdir}/libHUpnp.so

#--------------------------------------------------------------------

%prep
%setup -q -n %{srcname}-%{version}
%patch0 -p1


%build
%qmake_qt4 %{srcname}.pro

%make_build

%install
%makeinstall_std
mkdir -p %{buildroot}%{_libdir}
mkdir -p %{buildroot}%{_includedir}/HUpnpCore
pushd hupnp/bin
mv lib* %{buildroot}%{_libdir}
popd
pushd hupnp/deploy/include/HUpnpCore/
mv * %{buildroot}%{_includedir}/HUpnpCore/
popd


%changelog
