Group: Engineering
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# TODO: shared lib calls exit

Name:           iec16022
Version:        0.3.1
Release:        alt1_6
Summary:        Generate ISO/IEC 16022 2D barcodes

License:        GPL-2.0-or-later
URL:            https://github.com/rdoeffinger/iec16022
Source0:        https://github.com/rdoeffinger/%{name}/releases/download/v%{version}/%{name}-%{version}.tar.xz
Source1:        https://github.com/rdoeffinger/%{name}/releases/download/v%{version}/%{name}-%{version}.tar.xz.asc
Source2:        https://keys.openpgp.org/vks/v1/by-fingerprint/C61D16E59E2CD10C895838A40899A2B906D4D9C7

BuildRequires:  gnupg2
BuildRequires:  gcc
BuildRequires:  libpopt-devel
Requires:       %{name}-libs = %{version}-%{release}
Source44: import.info


%description
The iec16022 is a program for producing ISO/IEC 16022 2D barcodes, also
known as Data Matrix. These barcodes are defined in the ISO/IEC 16022
standard.

%package        libs
Group: System/Libraries
Summary:        ISO/IEC 16022 libraries

%description    libs
The iec16022-libs package provides libraries for producing ISO/IEC 16022
2D barcodes, also known as Data Matrix. These barcodes are defined in the
ISO/IEC 16022 standard.

%package        devel
Group: Development/Other
Summary:        Development files for the iec16022 library
Requires:       %{name}-libs = %{version}-%{release}
Requires:       pkgconfig

%description    devel
The iec16022-devel package includes header files and libraries necessary
for developing programs which use the iec16022 C library.


%prep
%setup -q


%build
%configure --disable-static
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%make_build


%install
%makeinstall_std
rm -f $RPM_BUILD_ROOT%{_libdir}/libiec16022.la


%check
export LD_LIBRARY_PATH=$RPM_BUILD_ROOT%{_libdir}
make -C test check





%files
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%files libs
%doc --no-dereference COPYING
%doc AUTHORS NEWS README
%{_libdir}/libiec16022.so.*

%files devel
%{_includedir}/%{name}/
%{_libdir}/libiec16022.so
%{_libdir}/pkgconfig/libiec16022.pc


%changelog
