# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name ikarus
%define version 0.0.3
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

Name:           ikarus
Version:        0.0.3
Release:        alt1_17
Summary:        An incremental optimizing compiler for R6RS Scheme

Group:          Development/Other
License:        GPLv3
URL:            http://ikarus-scheme.org/
Source0:        http://ikarus-scheme.org/ikarus-%{version}.tar.gz
#Patch0:         ikarus-0.0.1-bootfile.patch

# 391531 (x86_64), 391541 (ppc), 391551 (ppc64)
ExclusiveArch:  %{ix86}

BuildRequires:  libgmp-devel libgmpxx-devel chkconfig update-alternatives
Source44: import.info
#Requires:       

%description
Ikarus Scheme is a free optimizing incremental native-code compiler
for Scheme as specified in the Revised^6 Report on the Algorithmic
Language Scheme.

Ikarus Scheme is an optimizing compiler, so your Scheme code will run
fast without the need to port hot spots to C "for performance". With
an incremental compiler, you don't need a separate compilation step to
make your program run fast. The best part is that the compiler itself
is fast, capable of compiling thousands of lines of code per second.

Finally, Ikarus Scheme is an R6RS compiler. R6RS is the latest
revision of the Scheme standard. The current release of Ikarus
supports over 90% of the most important features R6RS, and later
releases will bring Ikarus closer to full R6RS conformance. R6RS
libraries, scripts, record types, condition system, exception
handling, unicode strings, bytevectors, hashtable, and enumerations
are among the supported features.Ikarus is a free optimizing
incremental native-code compiler for R6RS Scheme.


%prep
%setup -q
#%patch0 -p1 -b .bootfile


%build
%configure --docdir=%{_docdir}/%{name}
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT

# rename scheme-script
cd $RPM_BUILD_ROOT%{_bindir}
mv scheme-script ikarus-scheme-script
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/scheme-script_ikarus<<EOF
%{_bindir}/scheme-script	%{_bindir}/ikarus-scheme-script	80
EOF

%files
%_altdir/scheme-script_ikarus
%doc %{_docdir}/%{name}
%{_bindir}/*
%{_libdir}/ikarus


%changelog
