Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Archive/Zip.pm) perl(Compress/Zlib.pm) perl(Digest/SHA.pm) perl(Digest/SHA1.pm) perl(File/Slurp.pm) perl(MIME/Lite.pm) perl(PAR.pm) perl(PAR/Dist.pm) perl(PAR/Filter/PatchContent.pm) perl(PAR/Filter/PodStrip.pm) perl(PAR/Heavy.pm) perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %{perl_vendor_privlib}/ImVirt/VMD/*
BuildRequires: perl(Module/Find.pm)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       imvirt
Summary:    Detects several virtualizations
Version:    0.9.6
Release:    alt2_35
URL:        http://micky.ibh.net/~liske/imvirt.html
Source0:    http://downloads.sourceforge.net/project/%{name}/%{name}/%{version}/%{name}-%{version}.tar.gz
License:    GPL-2.0-only
Requires:   dmidecode
BuildRequires: rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: gcc
ExclusiveArch: %{ix86} x86_64 ia64
Source44: import.info

%description
This little Perl script tries to detect if it is called from within 
a virtualization container. This is detected by looking for well known boot 
messages, directories and reading DMI (Desktop Management Interface) data.

The following containers are detected:

    * Virtual PC/Virtual Server
    * VirtualBox
    * VMware
    * QEMU/KVM (experimental)
    * Xen (para and non-para virtualized)
    * OpenVZ/Virtuozzo
    * UML
    * any HVM providing CPUID 0x40000000 detection
    * lguest
    * ARAnyM
    * LXC

%prep
%setup -q

%build
%configure --prefix=%{_prefix} --libexec=%{_libexecdir}/imvirt
%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT

rm $RPM_BUILD_ROOT%{perl_vendor_archlib}/auto/ImVirt/.packlist
rm $RPM_BUILD_ROOT%{perl_vendor_archlib}/perllocal.pod

%files
%{_sbindir}/imvirt-report
%{_bindir}/*
%dir %{_libexecdir}/imvirt
%{_libexecdir}/imvirt/*
%doc AUTHORS COPYING ChangeLog README
%{_mandir}/man1/*.1*
%{perl_vendor_privlib}/*

%changelog
