Group: System/Servers
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           inadyn-mt
Version:        2.28.10
Release:        alt2_19
Summary:        Dynamic DNS Client
License:        GPLv3
URL:            http://inadyn-mt.sourceforge.net
Source0:        http://prdownloads.sourceforge.net/inadyn-mt/inadyn-mt.v.0%{version}.tar.gz
Source1:        inadyn-mt.conf
Source2:        inadyn.service
Source3:        inadyn-nm-dispatcher
Patch1:         inadyn-mt-libao.patch
# https://gitlab.com/bhoover/inadyn-mt/commit/84c18b121886e22375e2163d495f75a207b96d11
Patch2:         inadyn-mt-gcc10.patch
Patch3: inadyn-mt-c99.patch

BuildRequires:  automake
BuildRequires:  autoconf
BuildRequires:  gcc
BuildRequires:  libao-devel

Obsoletes:      inadyn < %{version}
Provides:       inadyn = %{version}-%{release}

Requires(pre):    shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-submap shadow-utils

Obsoletes:      inadyn-mt-units < %{version}-%{release}
Provides:       inadyn-mi-units = %{version}-%{release}

Obsoletes:      inadyn-mt-sysvinit < %{version}-%{release}
Provides:       inadyn-mt-sysvinit = %{version}-%{release}
Source44: import.info


%description
INADYN-MT is a dynamic DNS client. It maintains the IP address of 
a host name. It periodically checks whether the IP address stored
by the DSN server is the real current address of the machine that
is running INADYN-MT.

Before using inadyn-mt for the first time you must use the DynDNS
provider's web interface to create the entry for the hostname. You
should then fill in /etc/inadyn.conf with the appropriate detail

%prep
%setup -q -n %name.v.0%{version}
%patch1 -p1 -b .libao
%patch2 -p1 -b .gcc10
%patch3 -p1

%build
rm -rf bin/
autoreconf
%configure --prefix=/usr/share
%make_build CFLAGS="$RPM_OPT_FLAGS"

%install
mkdir -p $RPM_BUILD_ROOT%{_sbindir}
install -m 0755 src/inadyn-mt $RPM_BUILD_ROOT%{_sbindir}/inadyn

mkdir -p $RPM_BUILD_ROOT%{_mandir}/man5
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
install -p -m 0644 man/inadyn.8 $RPM_BUILD_ROOT%{_mandir}/man8
install -p -m 0644 man/inadyn.conf.5 $RPM_BUILD_ROOT%{_mandir}/man5

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}
install -p -m 0644 %{SOURCE1} $RPM_BUILD_ROOT%{_sysconfdir}

mkdir -p $RPM_BUILD_ROOT%{_datadir}/inadyn-mt/lang
cp lang/* $RPM_BUILD_ROOT%{_datadir}/inadyn-mt/lang

mkdir -p $RPM_BUILD_ROOT%{_datadir}/inadyn-mt/extra
cp -R extra/* $RPM_BUILD_ROOT%{_datadir}/inadyn-mt/extra

mkdir -p ${RPM_BUILD_ROOT}%{_unitdir}
install -p -m 0644 %{SOURCE2} ${RPM_BUILD_ROOT}%{_unitdir}

mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/lib/NetworkManager/dispatcher.d
install -p %{SOURCE3} ${RPM_BUILD_ROOT}%{_prefix}/lib/NetworkManager/dispatcher.d/30-inadyn

mkdir -p $RPM_BUILD_ROOT/var/cache/inadyn-mt

%pre
getent group inadyn >/dev/null || groupadd -r inadyn
getent passwd inadyn >/dev/null || \
    useradd -r -g inadyn -d /var/cache/inadyn-mt -s /sbin/nologin \
    -c "Dynamic DNS client" inadyn
exit 0

%post
%post_service inadyn
[ $1 -gt 1 ] && chown -R inadyn: /var/cache/inadyn-mt || :

%preun
%preun_service inadyn

%files 
%doc --no-dereference COPYING
%doc readme.html
%{_sbindir}/inadyn
%{_unitdir}/inadyn.service
%{_mandir}/man*/*
%attr(640,inadyn,inadyn) %config(noreplace) %{_sysconfdir}/%{name}.conf
%{_prefix}/lib/NetworkManager/
%{_datadir}/%{name}/
%attr(755,inadyn,inadyn) %dir /var/cache/inadyn-mt/

%changelog
