# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define fedora 19
Name:           inetvis
Version:        0.9.3.1
Release:        alt1_10
Summary:        3-D scatter-plot visualization for network traffic
Group:          File tools
License:        GPLv2
URL:            http://www.cs.ru.ac.za/research/g02v2468/inetvis.html
Source0:        http://www.cs.ru.ac.za/research/g02v2468/inetvis/0.9.3/%{name}-%{version}.tar.gz
Source1:        %{name}.desktop
Patch1:         %{name}-0.9.3.1-build.patch
Patch2:		%{name}-0.9.3.1-cstdio.patch

BuildRequires:  libX11-devel
BuildRequires:  libGL-devel
BuildRequires:  libGLU-devel
BuildRequires:  libXext-devel
BuildRequires:  libXmu-devel
BuildRequires:  libpcap-devel
BuildRequires:  desktop-file-utils

%if 0%{?fedora} < 9
BuildRequires:  qt3-devel
%else
BuildRequires:  qt3-devel
%endif
Source44: import.info

%description
InetVis is a 3-D scatter-plot visualization for network traffic.
In way, it's more or less like a media player, but for network traffic.
It's quite handy for observing scan activity and other anomolous
traffic patterns.

%prep
%setup -q
%patch1 -p1 -b .build
%patch2 -p1 -b .cstdio

%build
#%%configure
pushd src
qmake-qt3 'QMAKE_CFLAGS_RELEASE += -DINETVIS_DOCDIR=\"%{_docdir}/%{name}-%{version}/\"'
make %{?_smp_mflags}
popd
# fix permissions
chmod 644 doc/images/* doc/inetvisdoc.html
chmod 755 doc/ doc/images/

%install
#setup directories
mkdir -p %{buildroot}/%{_bindir}
install -m 755 src/inetvis %{buildroot}/%{_bindir}/
%if 0%{?fedora} && 0%{?fedora} < 19
desktop-file-install --vendor="fedora" --dir=${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE1}
%else
desktop-file-install --dir=${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE1}
%endif

%files
%{_bindir}/inetvis
%if 0%{?fedora} && 0%{?fedora} < 19
%{_datadir}/applications/fedora-%{name}.desktop
%else
%{_datadir}/applications/%{name}.desktop
%endif
%doc doc/*

%changelog
