# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Partly based on Debian package by Ben Finney <ben+debian@benfinney.id.au>
# https://packages.debian.org/sid/inform6-compiler

# TODO: Package main `inform6` packaged based on https://github.com/DavidGriffith/inform6unix
# and Ben's packaging at https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=805704

%define uname   Inform6
%define oname   inform6

Name:           inform6-compiler
Version:        6.34
Release:        alt1_2
Summary:        Inform 6 interactive fiction language a.. compiler
Group:          Development/Other
License:        Artistic 2.0
URL:            https://inform-fiction.org
Source0:        https://github.com/DavidKinder/Inform6/archive/v%{version}/%{uname}-%{version}.tar.gz
Source1:        Makefile.upstream
Source2:        %{oname}.1
Source44: import.info

%description
Inform 6 is an object-oriented language for writing interactive fiction,
also known as a.'text adventuresa.' or a.'adventure gamesa.'.

As an interactive fiction developer, you create Inform 6 source code defining
the story. Then compile from source code to a a.'story filea.'. The resulting
story files are highly portable, with interpreters available for many
different platforms.

The Inform 6 compiler can produce a story file in these formats:
 * Z-code, executed by implementations of the Infocom Z-machine.
 * Glulx, a modern platform for interactive fiction.

%prep
%setup -q -n %{uname}-%{version}

cp %{_sourcedir}/Makefile.upstream Makefile

%build

CFLAGS+=' -DLINUX'
CFLAGS+=' -DInclude_Directory=\"%{_datadir}/%{oname}/library\"'
CFLAGS+=' -DModule_Directory=\"%{_datadir}/%{oname}/modules\"'
export CFLAGS

%make_build

%install
install -d %{buildroot}%{_bindir}
install -m755 %{oname} %{buildroot}%{_bindir}
ln -s %{oname} %{buildroot}%{_bindir}/inform

install -d %{buildroot}%{_mandir}/man1
install -m644 %{_sourcedir}/%{oname}.1 %{buildroot}%{_mandir}/man1
ln -s %{oname}.1 %{buildroot}%{_mandir}/man1/inform.1

%files
%doc DebugFileFormat.txt readme.txt ReleaseNotes.html
%doc --no-dereference licence.txt
%{_bindir}/inform
%{_bindir}/inform6
%{_mandir}/man1/inform.1*
%{_mandir}/man1/inform6.1*


%changelog
