Group: Publishing
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 4

%global majorversion 7.2

Name:           ipe
Version:        7.2.26
Release:        alt1_%autorelease
Summary:        Drawing editor for creating figures in PDF or PostScript formats
# GPLv2, with an exception for the CGAL libraries.
License:        GPLv2+ with exceptions
URL:            http://ipe.otfried.org/
Source0:        https://github.com/otfried/%{name}/releases/download/v%{version}/%{name}-%{version}-src.tar.gz
Source1:        %{name}.desktop
Patch0:         %{name}-%{version}-gcc11.patch

BuildRequires:	gcc-c++
BuildRequires:	desktop-file-utils
BuildRequires:	qt5-base-devel
BuildRequires:	libcairo-devel
BuildRequires:	libfreetype-devel
BuildRequires:	libpng-devel libpng17-tools
BuildRequires:	lua-devel
BuildRequires:	curl-devel
BuildRequires:	libgsl-devel
BuildRequires:	libjpeg-devel
BuildRequires:	libspiro-devel
BuildRequires:	libqtspell-qt5-devel

Requires:       tex(latex)
Requires:       urw-fonts
Requires:       xdg-utils
Requires:       libqt5-svg

Provides:       ipe(api) = %{version}
Provides:       ipetoipe = %{version}
Provides:       ipetopng = %{version}
Source44: import.info

%description
Ipe is a drawing editor for creating figures in PDF or (encapsulated)
Postscript format. It supports making small figures for inclusion into
LaTeX-documents as well as making multi-page PDF presentations that
can be shown on-line with a PDF viewer


%package devel
Group: Development/Other
Summary: Development files and documentation for designing Ipelets
Requires: %{name} = %{version}-%{release}
%description devel 
This packages contains the files necessary to develop Ipelets, which are
plugins for the Ipe editor.

%package doc
Group: Documentation
BuildArch: noarch
Summary: Documentation of Ipe
Requires: %{name} = %{version}-%{release}
%description doc
%{summary}.

%prep
%setup -n %{name}-%{version} -q
%patch0 -p1

# fix files permissions
find src -type f -exec chmod -x {} +


%build
export QTDIR=%{qtdir}

pushd src
%make_build LUA_CFLAGS="`pkg-config --cflags lua`" \
     LUA_LIBS="`pkg-config --libs lua`" \
     MOC=moc-qt5 \
     IPEPREFIX="%{_prefix}" IPELIBDIR="%{_libdir}" \
     IPELETDIR="%{_libdir}/%{name}/%{version}/ipelets" \
     IPECURL=1 IPEGSL=1
popd 


%install
pushd src
make INSTALL_ROOT=%{buildroot} install \
     IPEPREFIX="%{_prefix}" IPELIBDIR="%{_libdir}" \
     IPELETDIR="%{_libdir}/%{name}/%{version}/ipelets" \
     INSTALL_PROGRAMS="install -m 0755"
popd

# Install desktop file
desktop-file-install --dir %{buildroot}%{_datadir}/applications %{SOURCE1}

%files
%doc --no-dereference gpl.txt
%doc readme.txt news.txt

%{_bindir}/ipe
%{_bindir}/ipe6upgrade
%{_bindir}/ipecurl
%{_bindir}/ipeextract
%{_bindir}/iperender
%{_bindir}/iperender-par
%{_bindir}/ipescript
%{_bindir}/ipetoipe
%{_bindir}/ipepresenter

%{_libdir}/libipe.so.%{version}
%{_libdir}/libipeui.so.%{version}
%{_libdir}/libipecairo.so.%{version}
%{_libdir}/libipecanvas.so.%{version}
%{_libdir}/libipelua.so.%{version}

%dir %{_libdir}/ipe
%{_libdir}/ipe/%{version}/ipelets/*

%dir %{_datadir}/ipe
%dir %{_datadir}/ipe/%{version}
%{_datadir}/ipe/%{version}/icons
%{_datadir}/ipe/%{version}/lua
%{_datadir}/ipe/%{version}/styles

%{_datadir}/applications/*%{name}*.desktop

%{_mandir}/man1/ipe.1*
%{_mandir}/man1/ipe6upgrade.1*
%{_mandir}/man1/ipeextract.1*
%{_mandir}/man1/iperender.1*
%{_mandir}/man1/ipescript.1*
%{_mandir}/man1/ipetoipe.1*
%dir %{_libdir}/ipe/%{version}
%dir %{_libdir}/ipe/%{version}/ipelets

%files devel
%doc --no-dereference gpl.txt
%doc readme.txt news.txt
%{_includedir}/*.h
%{_libdir}/libipe.so
%{_libdir}/libipeui.so
%{_libdir}/libipecairo.so
%{_libdir}/libipecanvas.so
%{_libdir}/libipelua.so

%files doc
%doc --no-dereference gpl.txt
%doc readme.txt gpl.txt news.txt
%{_datadir}/%{name}/%{version}

%changelog
