Group: Engineering
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global _hardened_build 1
Name:             irsim
Version:          9.7.104
Release:          alt2_14
Summary:          Switch-level simulator used even for VLSI

License:          GPLv2
URL:              http://opencircuitdesign.com/%{name}
Source0:          http://opencircuitdesign.com/%{name}/archive/%{name}-%{version}.tgz
BuildRequires:    gcc
BuildRequires:    tk-devel m4 libXt-devel
Source44: import.info

%description
IRSIM is a tool for simulating digital circuits. It is a "switch-level"
simulator; that is, it treats transistors as ideal switches. Extracted
capacitance and lumped resistance values are used to make the switch a little
bit more realistic than the ideal, using the RC time constants to predict the
relative timing of events.

%prep
%setup -q


%build
# The sources heavily rely on implicit ints and implicit function
# declarations and are not compatible with C99.
%global build_type_safety_c 0

# ./configure kills CFLAGS
# Invoke scripts/configure directly
(cd scripts && %configure)
%make_build

%install
%makeinstall_std
mv %{buildroot}%{_libdir}/%{name}/doc/*.doc doc/
rm -rf %{buildroot}%{_libdir}/%{name}/doc/

%files
%doc COPYRIGHT README VERSION doc/
%{_bindir}/*
%{_libdir}/*
# wildcard _libdir/*
%exclude %_prefix/lib/debug
%{_mandir}/man1/%{name}*
%{_mandir}/man5/netchange.5*
%{_mandir}/man3/%{name}-analyzer.3*

%Changelog
* Sat Mar 23 2024 Igor Vlasenko <viy@altlinux.org> 9.7.104-alt2_14
- update to new release by fcimport

* Thu Aug 31 2023 Igor Vlasenko <viy@altlinux.org> 9.7.104-alt2_12
- update to new release by fcimport

* Wed Feb 22 2023 Igor Vlasenko <viy@altlinux.org> 9.7.104-alt2_10
- update to new release by fcimport

* Sun Aug 07 2022 Igor Vlasenko <viy@altlinux.org> 9.7.104-alt2_8
- update to new release by fcimport

* Sat Feb 05 2022 Igor Vlasenko <viy@altlinux.org> 9.7.104-alt2_7
- update to new release by fcimport

* Mon Aug 02 2021 Igor Vlasenko <viy@altlinux.org> 9.7.104-alt2_6
- update to new release by fcimport

* Wed Mar 17 2021 Igor Vlasenko <viy@altlinux.org> 9.7.104-alt2_5
- update to new release by fcimport

* Wed Jan 27 2021 Igor Vlasenko <viy@altlinux.ru> 9.7.104-alt2_4
- update to new release by fcimport

* Wed Sep 02 2020 Igor Vlasenko <viy@altlinux.ru> 9.7.104-alt1_4
- update to new release by fcimport

* Thu Mar 05 2020 Igor Vlasenko <viy@altlinux.ru> 9.7.104-alt1_3
- update to new release by fcimport

* Tue Aug 06 2019 Igor Vlasenko <viy@altlinux.ru> 9.7.104-alt1_2
- update to new release by fcimport

* Thu May 23 2019 Igor Vlasenko <viy@altlinux.ru> 9.7.103-alt1_1
- update to new release by fcimport

* Fri Mar 01 2019 Igor Vlasenko <viy@altlinux.ru> 9.7.100-alt1_3
- update to new release by fcimport

* Wed Aug 01 2018 Igor Vlasenko <viy@altlinux.ru> 9.7.100-alt1_2
- update to new release by fcimport

* Fri May 04 2018 Igor Vlasenko <viy@altlinux.ru> 9.7.100-alt1_1
- update to new release by fcimport

* Tue Feb 20 2018 Igor Vlasenko <viy@altlinux.ru> 9.7.96-alt1_2
- update to new release by fcimport

* Wed Sep 27 2017 Igor Vlasenko <viy@altlinux.ru> 9.7.96-alt1_1
- update to new release by fcimport

* Mon Apr 10 2017 Cronbuild Service <cronbuild@altlinux.org> 9.7.95-alt2_2
- rebuild to get rid of unmets

* Wed Mar 15 2017 Igor Vlasenko <viy@altlinux.ru> 9.7.95-alt1_2
- update to new release by fcimport

* Thu Nov 17 2016 Igor Vlasenko <viy@altlinux.ru> 9.7.95-alt1_1
- update to new release by fcimport

* Fri Sep 30 2016 Igor Vlasenko <viy@altlinux.ru> 9.7.94-alt1_1
- update to new release by fcimport

* Wed Mar 02 2016 Igor Vlasenko <viy@altlinux.ru> 9.7.92-alt1_2
- update to new release by fcimport

* Mon Sep 21 2015 Igor Vlasenko <viy@altlinux.ru> 9.7.92-alt1_1
- update to new release by fcimport

* Wed Sep 10 2014 Igor Vlasenko <viy@altlinux.ru> 9.7.87-alt1_2
- update to new release by fcimport

* Mon Jul 07 2014 Igor Vlasenko <viy@altlinux.ru> 9.7.87-alt1_1
- update to new release by fcimport

* Tue Aug 27 2013 Igor Vlasenko <viy@altlinux.ru> 9.7.68-alt1_8
- update to new release by fcimport

* Fri Mar 08 2013 Igor Vlasenko <viy@altlinux.ru> 9.7.68-alt1_7
- update to new release by fcimport

* Mon Jan 21 2013 Igor Vlasenko <viy@altlinux.ru> 9.7.68-alt1_6
- initial fc import

