Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: libsensors3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		istatd
Version:	0.5.8
Release:	alt1_21
Summary:	Daemon serving statistics to your iStat iPhone application

License:	BSD
URL:		https://github.com/tiwilliam/istatd
Source0:	https://github.com/downloads/tiwilliam/istatd/istatd-%{version}.tar.gz
Source1:	istatd.service
Source2:	istatd-tmpfiles.conf

BuildRequires:  gcc-c++
BuildRequires:	libxml2-devel
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-networkd systemd-portable systemd-services systemd-stateless systemd-sysvinit systemd-utils
Requires(pre):	shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Source44: import.info


%description
istatd is a daemon serving statistics to your iStat iPhone
application from Linux, Solaris & FreeBSD.
istatd collects data such as CPU, memory, network and disk
usage and keeps the history.
Once connecting from the iPhone and entering the lock code
this data will be sent to the iPhone and shown in fancy graphs.


%prep
%setup -q


%build
%configure
%make_build


%install
make install DESTDIR=%{buildroot}
mkdir -p %{buildroot}/run/istat
mkdir -p %{buildroot}/%{_var}/cache/istat
mkdir -p %{buildroot}/%{_unitdir}
mkdir -p %{buildroot}/%{_tmpfilesdir}
install -p -m 644 %{SOURCE1} %{buildroot}/%{_unitdir}/
install -p -m 644 %{SOURCE2} %{buildroot}/%{_tmpfilesdir}/istatd.conf


%pre
getent group istat >/dev/null || groupadd -r istat
getent passwd istat >/dev/null || \
    useradd -r -g istat -d /var/run/istat -s /sbin/nologin \
    -c "istatd daemon user" istat
exit 0


%post
%post_service istatd

%preun
%preun_service istatd

%files
%doc AUTHORS.txt CHANGELOG.txt DEVELOPERS.txt README.txt
%{_bindir}/istatd
%config(noreplace) %{_sysconfdir}/istat.conf
%{_mandir}/man1/istatd.1*
%{_mandir}/man5/istat.conf.5*
%attr(750, istat, istat) %{_var}/cache/istat
%attr(750, istat, istat) /run/istat
%{_unitdir}/istatd.service
%{_tmpfilesdir}/istatd.conf


%changelog
