# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 0.54
%global sum     Graphical roguelike game with innovative gameplay and sarcastic humor
%define uversion %(echo %{version} | tr -d '.')

Name:           ivan
Version:        0.54
Release:        alt1_5
Summary:        %{sum}
Group:          Games/Adventure
License:        GPLv2+ and CC-BY-SA
URL:            https://attnam.com
Source0:        https://github.com/Attnam/ivan/archive/v%{uversion}/%{name}-%{uversion}.tar.gz

Patch0:         ivan-pr490-USE_HOME_FOR_STATE_DIR-option.patch
Patch1:         0001-Fix-Werror-format-security-errors-in-FeLib.patch

BuildRequires:  cmake
BuildRequires:  libicns-utils
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(libpcre)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_mixer)
Source44: import.info

%description
Fellow adventurer, turn back while you can! For here begins the roguelike
Iter Vehemens ad Necem, a Violent Road to Death. If you choose to travel
along it, you will dive into countless exciting adventures to gain items of
great magic, attain powerful equipment made of mysterious materials, bathe in
the blessings of mighty gods and recruit loyal allies of various shapes and
sizes. Unfortunately, along the way you will also often be dangerously
injured, poisoned, catch numerous diseases, lose several limbs and transform
into manifold different kinds of pitiful creatures in the darkest depths of
hostile dungeons. And, at the end of the road, you are bound to perish in a
most gruesome and painful way.
Don't say we didn't warn you.

%prep
%setup -q -n %{name}-%{uversion}
%patch0 -p1
%patch1 -p1


%build
%{mageia_cmake} \
    -DBUILD_SHARED_LIBS=OFF \
    -DCMAKE_INSTALL_BINDIR=%{_gamesbindir} \
    -DCMAKE_INSTALL_DATADIR=%{_gamesdatadir} \
    -DUSE_HOME_FOR_STATE_DIR=ON
%mageia_cmake_build

%install
%mageia_cmake_install

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/com.attnam.%{name}.desktop
[Desktop Entry]
Name=Iter Vehemens ad Necem
GenericName=Roguelike game
Comment=%{sum}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;RolePlaying;
EOF

icns2png -x ci/osx/IVAN.app/Contents/Resources/ivan.icns
for size in 16x16 32x32 128x128; do
    install -D -m644 ivan_${size}x32.png %{buildroot}%{_iconsdir}/hicolor/${size}/apps/%{name}.png
done

%files
%doc AUTHORS NEWS README.md
%doc --no-dereference COPYING LICENSING
%{_datadir}/applications/com.attnam.%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
