# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           iyfct
Version:        1.02
Release:        alt1_7
Summary:        In Your Face City Trains: coffee-break runner game
Group:          Games/Arcade
License:        GPLv3+ and CC-BY 3.0
URL:            https://simonlarsen.github.io/2011/05/29/in-your-face-city-trains.html
Source0:        https://github.com/SimonLarsen/iyfct/archive/v%{version}/%{name}-%{version}.tar.gz
Source1:        iyfct-48.png
Patch0:         iyfct-1.02-mga-Support-fkeys-and-numpad-for-scaling.patch
Patch1:         0001-Fixed-API-changes-for-love-0.10.x.patch
Patch2:         0002-Add-support-for-scales-5-and-6.patch

BuildArch:      noarch
BuildRequires:  zip
Requires:       love0.10
Source44: import.info

%description
The goal of the game is to survive as long as you can. Jump over trains with
closed doors and try (as much as possible) to run through trains with open
doors to avoid birds and tunnels. Some open trains will give you coffee.
When your coffee-meter is full, you have one extra life.

%files
%doc LICENSE README.textile
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/%{name}.love
%{_iconsdir}/hicolor/48x48/apps/%{name}.png

#----------------------------------------------------------------------------

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

mv LICENCE LICENSE

%build
# Create .love archive
zip -9 -q -r %{name}.love .

# Launcher script
cat << EOF > %{name}.sh
#!/bin/sh
love0.10 %{_gamesdatadir}/%{name}/%{name}.love
EOF

# Desktop entry
cat > %{name}.desktop << EOF
[Desktop Entry]
Name=In Your Face City Trains
GenericName=Runner game
Comment=Survive as long as you can on a frenetic city railway
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF

%install
install -D -m644 %{name}.love %{buildroot}%{_gamesdatadir}/%{name}/%{name}.love
install -D -m755 %{name}.sh %{buildroot}%{_gamesbindir}/%{name}
install -D -m644 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop
install -D -m644 %{_sourcedir}/%{name}-48.png %{buildroot}%{_iconsdir}/hicolor/48x48/apps/%{name}.png


%changelog
