Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       jasmine-node
Version:    1.14.3
Release:    alt1_14
Summary:    DOM-less JS behavior-driven development (BDD) testing framework for Node
License:    MIT
URL:        https://github.com/mhevery/jasmine-node
Source0:    http://registry.npmjs.org/jasmine-node/-/jasmine-node-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

# Remove the version from jasmine.js location.
Patch0:     %{name}-1.14.3-Fix-location-of-jasmine.js.patch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  coffee-script
BuildRequires:  npm(fileset)
BuildRequires:  npm(gaze)
BuildRequires:  npm(jasmine-reporters)
BuildRequires:  npm(jasmine-growl-reporter)
BuildRequires:  npm(mkdirp)
BuildRequires:  npm(requirejs)
BuildRequires:  npm(walkdir)
# These are required for the files we're unbundling.
BuildRequires:  jasmine
BuildRequires:  npm(require-cs)
%endif

# We are symlinking to these files, so explicitly depend on them just in case
# the packages that own them decide to move them somewhere else.
Requires:       /usr/lib/node_modules/require-cs/cs.js
Requires:       /usr/share/jasmine/jasmine.js
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%patch0 -p1
rm -f lib/jasmine-node/cs.js
rm -f lib/jasmine-node/jasmine-*.js
# Lots of files are executable but shouldn't be.
find . -type f ! -iname 'specs*' -exec chmod 0644 '{}' \;

%nodejs_fixdep gaze '~0.5'
%nodejs_fixdep jasmine-growl-reporter '~0.2'
%nodejs_fixdep mkdirp '^0.5.1'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/jasmine-node
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/jasmine-node
mkdir -p %{buildroot}%{nodejs_sitelib}/jasmine-node/bin
install -p -D -m0755 bin/jasmine-node \
    %{buildroot}%{nodejs_sitelib}/jasmine-node/bin/jasmine-node
mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/jasmine-node/bin/jasmine-node \
    %{buildroot}%{_bindir}/jasmine-node

# Replace bundled cs.js with symlink.
mkdir -p %{buildroot}%{nodejs_sitelib}/jasmine-node/lib/jasmine-node
ln -sf %{nodejs_sitelib}/require-cs/cs.js \
    %{buildroot}%{nodejs_sitelib}/jasmine-node/lib/jasmine-node/cs.js
# Replace bundled jasmine.js with symlink.
ln -sf %{_datadir}/jasmine/jasmine.js \
    %{buildroot}%{nodejs_sitelib}/jasmine-node/lib/jasmine-node/jasmine.js

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
ln -sf %{nodejs_sitelib}/require-cs/cs.js \
    lib/jasmine-node/cs.js
ln -sf %{_datadir}/jasmine/jasmine.js \
    lib/jasmine-node/jasmine.js
# Some of the tests fail, but apparently they *should* fail.
./specs.sh
%endif


%files
%doc LICENSE README.md
%{nodejs_sitelib}/jasmine-node
%{_bindir}/jasmine-node


%changelog
