# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          jcharset
Version:       1.5
Release:       alt1_10
Group:         Development/Java
Summary:       Java Charset package
License:       GPLv2+
URL:           http://www.freeutils.net/source/jcharset/
# to download the file prompts you to accept the license terms
# wget http://www.freeutils.net/source/jcharset/jcharset-1_5.zip
# mkdir -p jcharset-1.5
# cd jcharset-1.5
# unzip ../jcharset-1_5.zip
# lib/jcharset.jar
# rm -r lib
# cd ..
# tar czf jcharset-1.5-clean.tar.gz jcharset-1.5
Source0:       %{name}-%{version}-clean.tar.gz
# custom pom file required by davmail project
Source1:       %{name}-pom-template.xml
BuildRequires: java-devel-default /proc
BuildRequires: javapackages-local
BuildArch:     noarch
Source44: import.info

%description
The Java Charset package is an open-source implementation of
character sets that were missing from the standard Java platform. 

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q

cp -p %{SOURCE1} %{name}.pom
sed -i "s|@VERSION@|%{version}|" %{name}.pom
# fix wrong-file-end-of-line-encoding
sed -i 's/\r//' CHANGES.txt LICENSE.txt README.txt
# prepare incomplete build structure
mkdir docs

%build

%javac -encoding UTF-8 $(find src -type f -name "*.java")

(
  cd src
# include META-INF/services/java.nio.charset.spi.CharsetProvider
  %jar cvf ../%{name}.jar $(find . -name "*.class") META-INF
)

%javadoc -d docs -encoding UTF-8 -Xdoclint:none $(find src -type f -name "*.java")

%install
%mvn_file net.freeutils.charset:%{name} %{name}
%mvn_artifact %{name}.pom %{name}.jar
%mvn_install -J docs

%files -f .mfiles
%doc CHANGES.txt README.txt
%doc --no-dereference LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt



%changelog
