Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Copyright (c) 2015  Dave Love, University of Liverpool
# MIT licence, per Fedora policy

Name:           jcuber
Version:        4.8
Release:        alt1_6
Summary:        CUBE reader for Java
# tarviewer is ASL
License:        BSD-3-Clause AND Apache-2.0
URL:            http://www.scalasca.org/software/cube-4.x/download.html
Source0:        http://apps.fz-juelich.de/scalasca/releases/cube/%(echo %version|awk -F. '{print $1 "." $2}')/dist/jcuber-%version.tar.gz
BuildRequires:  java-devel
BuildRequires:  jpackage-utils
BuildRequires:  xerces-j2
Requires:       java jpackage-utils
Obsoletes:      cube-java <= 4.3.2-1
Provides:       cube-java = %version-%release
BuildArch:      noarch
Source44: import.info


%description
A CUBE reader written in Java.

%package        doc
Group: Other
Summary:        Documentation for %{name}
BuildArch:      noarch
Conflicts:      cube-java <= 4.3.2-1

%description    doc
The %{name}-doc package contains documentation for %{name}.

%prep
%setup -q


%build
%configure
# As an alternative to patching configure.ac and then worrying about
# autoconf268 in EPEL6:
sed -i -e s/jCubeR/jcuber/ -e 's|/cube|/jcuber|' bin/jcuber-config
# nothing to parallelize
make


%check
make check


%install
make install install-html DESTDIR=%buildroot
cp -rp examples AUTHORS %buildroot%_defaultdocdir/%name


%files
%dir %_defaultdocdir/%name
%doc --no-dereference COPYING
%_defaultdocdir/%name/AUTHORS
%_datadir/java/CubeReader.jar
# rpmlint complains, but I don't think they should be in a devel package --
# at least the file extension should be relevant at runtime.
%_bindir/jcuber-config*
%_datadir/jcuber
%exclude %_docdir/jcuber

%files doc
%_defaultdocdir/%name
%doc --no-dereference COPYING


%changelog
