# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/pathfix.py perl(Term/ANSIColor.pm) python3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global __python %{__python3}
Name:           jgmenu
Version:        4.4.1
Release:        alt1_2
Summary:        Small X11 menu intended to be used with openbox and tint2
Group:          Graphical desktop/Other
License:        GPLv2
URL:            https://github.com/johanmalm/jgmenu/wiki
Source0:        https://github.com/johanmalm/jgmenu/archive/v%{version}/%{name}-%{version}.tar.gz

# Add PR to fix registration with Xfce
Patch0:		https://github.com/jgmenu/jgmenu/pull/188.patch

BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xinerama)
BuildRequires:  pkgconfig(cairo)
BuildRequires:  pkgconfig(pango)
BuildRequires:  pkgconfig(librsvg-2.0)
BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(libmenu-cache)
BuildRequires:  pkgconfig(xrandr)
Source44: import.info

%description
- jgmenu is a stand-alone, simple and contemporary-looking menu application
  for Linux and BSD.
- Although it was originally written to be used with openbox and tint2,
  it is not in any way dependent on these and runs well with other panels
  and window managers.
- It is hackable with a clean, small code base.
- It can display the following types of menu (or any combination of):
  o  bespoke menu using a jgmenu flavoured CSV format
  o  application menu (XDG compatible) with localisation support
  o  openbox XML menu including pipe-menus
- It can display SVG, PNG and XPM icons.
- It has UTF-8 search support.
- It is highly customizable (e.g. colours, alignment, margins, padding,
  transparency).
- It can synchronise with xsettings, GTK and tint2 settings.
- It does not depend on any toolkits such as GTK and Qt, but uses cairo and
  pango to render the menu directly onto an X11 window.

%prep
%setup -q
%patch0 -p1


# Fix the path to Python 3
pathfix.py -pni "%{__python3} " \
contrib/gtktheme/jgmenu-gtktheme.py \
contrib/mate-panel/mate-jgmenu.py \
contrib/pmenu/jgmenu-pmenu.py \
src/jgmenu-unity-hack.py

%build
%configure
%make_build prefix=%{_prefix} libexecdir=%{_libdir}/%{name}

%install
%makeinstall_std prefix=%{_prefix} libexecdir=%{_libdir}/%{name}

%files
%doc README.md TODO.md
%{_bindir}/%{name}*
%{_libdir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_mandir}/man1/*
%{_mandir}/man7/*
%{_iconsdir}/hicolor/scalable/apps/%{name}.svg


%changelog
