# BEGIN SourceDeps(oneline):
BuildRequires: groff-ps
# END SourceDeps(oneline)
Group: Editors
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Jonathan's Own Version of Emacs
Name: jove
Version: 4.16.0.73
Release: alt1_16
License: Copyright only
URL: ftp://ftp.cs.toronto.edu/pub/hugh/jove-dev/
Source: ftp://ftp.cs.toronto.edu/pub/hugh/jove-dev/jove%{version}.tgz
BuildRequires:  gcc
BuildRequires: libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel groff-base groff-dvi groff-extra groff-lbp groff-lj4
%global configflags SYSDEFS="-DSYSVR4 -D_XOPEN_SOURCE=500 -DIPROC_TERM='\\"TERM=vanilla\\"'" NROFF="nroff -Tascii" TROFF=groff TROFFPOST=""
Source44: import.info

%description
Jove is a compact, powerful Emacs-style text-editor. It provides the common
emacs keyboard bindings, together with a reasonable assortment of the most
popular advanced features (e.g. interactive shell windows, compile-it,
language specific modes) while weighing in with CPU, memory, and disk
requirements comparable to vi(1).

%prep
%setup -q -n jove%{version}

%build
# Keep all three make commands consistent, except for JOVEHOME and targets.
# JOVEHOME must be the ultimate path since it will be compiled into JOVE.
make TERMCAPLIB=-ltinfo JOVEHOME=/usr LIBDIR=%{_libdir}/jove SHAREDIR=%{_datadir}/jove MANDIR=%{_mandir}/man1 OPTFLAGS="%{optflags}" %{configflags} all doc/jove.man doc/jove.man.ps
mv doc/jove.man doc/jove.man.txt

%install
# Keep all three make commands consistent, except for JOVEHOME and targets.
# JOVEHOME is a temporary home under $RPM_BUILD_ROOT/.
# This can be different from JOVEHOME for the build phase's make.
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}
mkdir -p $RPM_BUILD_ROOT%{_datadir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
make JOVEHOME=$RPM_BUILD_ROOT/usr LIBDIR=$RPM_BUILD_ROOT%{_libdir}/jove SHAREDIR=$RPM_BUILD_ROOT%{_datadir}/jove MANDIR=$RPM_BUILD_ROOT%{_mandir}/man1 OPTFLAGS="%{optflags}" %{configflags} install
mv doc/README doc/README.doc

# although we build jovetool.1 and xjove.1, we don't install them
rm $RPM_BUILD_ROOT%{_mandir}/man1/jovetool.1
rm $RPM_BUILD_ROOT%{_mandir}/man1/xjove.1


%files
%{_libdir}/jove/
%{_datadir}/jove/
%{_bindir}/jove
%{_bindir}/teachjove
%{_mandir}/man1/jove.1*
%{_mandir}/man1/teachjove.1*
%doc README doc/jove.man.txt doc/jove.man.ps doc/jove.qref 

%changelog
