Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# From GitLab tag: https://gitlab.com/LibreGames/jumpnbump/tags
%global uploadhash 95acdae2a232513f068e260977371dcf

Name:           jumpnbump
Version:        1.61
Release:        alt2_12
Summary:        Cute multiplayer platform game with bunnies
License:        GPLv2+
URL:            https://gitlab.com/LibreGames/jumpnbump
Source0:        https://gitlab.com/LibreGames/jumpnbump/uploads/%{uploadhash}/%{name}-%{version}.tar.xz
Patch0:         0001-Makefile-Set-fcommon-to-workaround-GCC-10-change.patch

BuildRequires:  bzlib-devel
BuildRequires:  gcc
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_mixer)
BuildRequires:  pkgconfig(SDL2_net)
BuildRequires:  pkgconfig(zlib)

# For desktop file validation
BuildRequires:  desktop-file-utils
# For AppStream metainfo validation
BuildRequires:  libappstream-glib libappstream-glib-gir

# For music support, dlopen()'ed by SDL2_music
Requires:       libmodplug

%if 0%{?fedora} || 0%{?rhel} >= 8
Requires:     %{name}-menu
%else
Requires:       %{name}-menu
%endif
Source44: import.info

%description
Jump 'n Bump is a cute multiplayer platform game in which you, as a bunny,
have to jump on your opponents to make them explode. It is a true multiplayer
game with network support and shouldn't be played alone, although computer
bunnies with limited AI are available. The game is a UNIX port of the old DOS
game by Brainchild Design.

%package menu
Group: Other
Summary:        Level selection and config menu for the Jump 'n Bump game
BuildArch:      noarch

BuildRequires:  gettext-tools
# For potential auto dep generation
%if 0%{?rhel} == 7
BuildRequires:  python36-devel
%else
BuildRequires:  python3-devel
%endif

Requires:       %{name} = %{version}-%{release}
Requires:       %{_bindir}/convert
%if 0%{?rhel} == 7
Requires:       python36-gobject
%else
Requires:       python3-module-pygobject3
%endif

%description menu
Python 3/GTK+3 based level selection and configuration interface for the Jump 'n
Bump game.

%prep
%setup -q
%patch0 -p1


%build
export CFLAGS="%{?__global_cflags}"
export LDFLAGS="%{?__global_ldflags}"

%make_build PREFIX=%{_prefix}
%make_build PREFIX=%{_prefix} -C menu

%install
%makeinstall_std PREFIX=%{_prefix}
%makeinstall_std PREFIX=%{_prefix} -C menu

%find_lang %{name}-menu

%check
# Validate desktop files
desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}{,-menu}.desktop

# Validate AppStream metainfo data
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/metainfo/%{name}.appdata.xml

%post
/bin/touch --no-create %{_datadir}/icons &>/dev/null || :

%postun
if [ $1 -eq 0 ] ; then
    /bin/touch --no-create %{_datadir}/icons &>/dev/null
:
fi

%files
%doc AUTHORS ChangeLog docs/* README.md
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_bindir}/gobpack
%{_bindir}/jnb*
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/jumpbump.dat
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/%{name}.png
%{_datadir}/metainfo/%{name}.appdata.xml
%{_mandir}/man6/%{name}.6*

%files menu -f %{name}-menu.lang
%doc menu/README.md
%doc --no-dereference COPYING
%{_bindir}/%{name}-menu
%{_datadir}/%{name}/%{name}_menu.glade
%{_datadir}/applications/%{name}-menu.desktop

%changelog
