Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install gcc-c++ perl(Term/Cap.pm) perl(URI.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Name:           kdesrc-build
Version:        1.15.1
Release:        alt1_12
Summary:        A tool to easily build KDE from its source repositories

License:        GPLv2+ and LGPLv3+ and BSD and GFDL
URL:            http://kdesrc-build.kde.org/
Source0:        ftp://ftp.kde.org/pub/kde/stable/kdesrc-build/1.15.1/src/%{name}-%{version}.tar.xz

# add missing key "Type"
Patch0:         %{name}-desktop-file.patch

BuildRequires:  desktop-file-utils
BuildRequires:  kde4libs-devel
# reqs for test suite
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Text/ParseWords.pm) perl(Test/More.pm) perl(Digest/MD5.pm) perl(Scalar/Util.pm) perl(Getopt/Long.pm)
BuildRequires:  perl(File/Temp.pm) perl(Storable.pm) perl(LWP/UserAgent.pm) perl(XML/Parser.pm)

BuildArch:      noarch

%description
kdesrc-build is a script to help users install KDE software from its Subversion
and Git source repositories. It used to be called kdesvn-build, the name was
changed to this more generic form in June 2010 when KDE started adopting
git-based source control.


%prep
%setup -q

%patch0


%build
mkdir -p %{_target_platform}
pushd %{_target_platform}
%{cmake_kde4} ..
popd
%make_build -C %{_target_platform}


%check
./kdesrc-build-test.pl --full-run


%install
make install/fast DESTDIR=%{buildroot} -C %{_target_platform}

install -pm 755 %{name} %{buildroot}%{_bindir}
install -pm 755 %{name}-setup %{buildroot}%{_bindir}

desktop-file-install --dir %{buildroot}%{_kde4_datadir}/applications/kde4 doc/%{name}.desktop


%files
%doc README LICENSE AUTHORS %{name}rc-sample COPYING.LIB doc/COPYING.DOC

%{_bindir}/%{name}
%{_bindir}/%{name}-setup

%{_kde4_datadir}/applications/kde4/%{name}.desktop

%{_kde4_appsdir}/katepart/syntax/%{name}rc.xml

%{_docdir}/HTML/*/%{name}

%{_mandir}/man1/%{name}.1*
%{_mandir}/man1/%{name}-setup.1*


%changelog
