Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++ libX11-devel libgtk+2-devel zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           keepassx0
Version:        0.4.4
Release:        alt2_20
Summary:        Cross-platform password manager

# apg/ and crypto/ directory contains BSD files
# only crypto/arcfour* files are GPLv2+ 
# all other source is GPLv2 licensed files
License:        GPLv2 and BSD
URL:            http://keepassx.sourceforge.net
Source0:        https://www.keepassx.org/releases/%{version}/keepassx-%{version}.tar.gz
Patch1:         keepassx-0.3.3-gcc43.patch
Patch2:         keepassx-0.4.3-gcc47.patch
BuildRequires:  libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools, libXtst-devel, ImageMagick-tools, desktop-file-utils
Requires:       icon-theme-hicolor
Obsoletes:      keepassx < 0:2.0
Source44: import.info

%description
KeePassX is an application for people with extremely high demands on secure
personal data management.
KeePassX saves many different information e.g. user names, passwords, urls,
attachements and comments in one single database. For a better management
user-defined titles and icons can be specified for each single entry.
Furthermore the entries are sorted in groups, which are customizable as well.
The integrated search function allows to search in a single group or the
complete database.
KeePassX offers a little utility for secure password generation. The password
generator is very customizable, fast and easy to use. Especially someone who
generates passwords frequently will appreciate this feature.
The complete database is always encrypted either with AES (alias Rijndael) or
Twofish encryption algorithm using a 256 bit key. Therefore the saved
information can be considered as quite safe. KeePassX 0.4.x uses a database format
that is compatible with KeePass Password Safe v1 for MS Windows.

%prep
%setup -qn keepassx-%{version}
%patch1 -p0 -b .gcc43
%patch2 -p1 -b .gcc47

sed -i s/keepassx/keepassx0/g src/src.pro
sed -i s/keepassx0.h/keepassx.h/g src/src.pro

%build
qmake-qt4 PREFIX=%{_prefix} \
      QMAKE_CFLAGS="$RPM_OPT_FLAGS" \
      QMAKE_CXXFLAGS="$RPM_OPT_FLAGS"
%make_build

%install
make install INSTALL_ROOT=$RPM_BUILD_ROOT 

# Use png in _datadir/icons/hicolor instead of xpm in pixmaps
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/32x32/apps/
convert $RPM_BUILD_ROOT%{_datadir}/pixmaps/keepassx.xpm \
        $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/32x32/apps/keepassx0.png
rm -f $RPM_BUILD_ROOT%{_datadir}/pixmaps/keepassx.xpm

mkdir -p $RPM_BUILD_ROOT%{_datadir}/keepassx
cp -r share/keepassx/* $RPM_BUILD_ROOT%{_datadir}/keepassx/

# Menu
mv $RPM_BUILD_ROOT%{_datadir}/applications/keepassx.desktop $RPM_BUILD_ROOT%{_datadir}/applications/keepassx0.desktop

# Rename the Exec file name
sed -i -e 's/^Exec=keepassx %f/Exec=keepassx0 %f/g' \
        $RPM_BUILD_ROOT%{_datadir}/applications/keepassx0.desktop
desktop-file-install \
        --dir $RPM_BUILD_ROOT%{_datadir}/applications \
        --delete-original \
        --add-mime-type application/x-keepass \
        $RPM_BUILD_ROOT%{_datadir}/applications/keepassx0.desktop

sed -i s/Name=KeePassX/Name=KeePassX\ 0.4.x/g %{buildroot}%{_datadir}/applications/keepassx0.desktop
sed -i s/Icon=keepassx/Icon=keepassx0/g %{buildroot}%{_datadir}/applications/keepassx0.desktop

# Associate KDB files
cat > x-keepassx0.desktop << EOF
[Desktop Entry]
Comment=
Hidden=false
Icon=keepassx0
MimeType=application/x-keepass;
Patterns=*.kdb;*.KDB
Type=MimeType
EOF
install -D -m 644 -p x-keepassx0.desktop \
  $RPM_BUILD_ROOT%{_datadir}/mimelnk/application/x-keepassx0.desktop


%files
%doc --no-dereference share/keepassx/license.html
%{_bindir}/keepassx0
%{_datadir}/keepassx
%{_datadir}/applications/*.desktop
%{_datadir}/mimelnk/application/*.desktop
%{_datadir}/mime/packages/*.xml
%{_datadir}/icons/hicolor/*/apps/keepassx0.png

%changelog
