# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libGLU-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum     Dungeon simulator game with roguelike elements
%define uver    alpha31.2
%define date    20201012

Name:           keeperrl
Version:        0.0.31.2
Release:        alt1_3
Summary:        %{sum}
Group:          Games/Adventure
License:        GPLv2+
URL:            https://keeperrl.com
Source0:        https://github.com/miki151/keeperrl/archive/%{uver}/%{name}-%{uver}.tar.gz
Source1:        %{name}-48.png
Source2:        %{name}-128.png
Source3:        %{name}-256.png

BuildRequires:  boost-complete
BuildRequires:  clang
BuildRequires:  pkgconfig(gl)
BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_image)
BuildRequires:  pkgconfig(openal)
BuildRequires:  pkgconfig(vorbis)
BuildRequires:  pkgconfig(zlib)
Source44: import.info

%description
KeeperRL is an Open Source dungeon simulator game inspired by Dungeon
Keeper and Dwarf Fortress. You become an evil wizard seeking the ultimate
knowledge of destruction. You can control your minions, and explore and
conquer the world in a roguelike fashion. Combat is turn-based and very
tactical. The whole world is procedurally generated.

This is the ASCII version of KeeperRL. See https://keeperrl.com/ for
information about the version with nonfree music and graphical tiles.

%prep
%setup -q -n %{name}-%{uver}


# Replace git-based version detection
cat << EOF > gen_version.sh
echo "#define BUILD_VERSION \"%{uver} (%{_vendor})\"" > version.h
echo "#define BUILD_DATE \"%{date}\"" >> version.h
EOF

%build

%make_build \
    RELEASE=ON \
    OPT=ON \
    NO_RPATH=ON \
    NO_STEAMWORKS=ON \
    DATA_DIR=%{_gamesdatadir}/%{name} \
    ENABLE_LOCAL_USER_DIR=ON

%install
install -D -m755 keeper %{buildroot}%{_gamesbindir}/%{name}

install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a data_contrib data_free %{buildroot}%{_gamesdatadir}/%{name}/
install -m644 appconfig.txt %{buildroot}%{_gamesdatadir}/%{name}/appconfig.txt

# Menu entry
install -d %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=KeeperRL
GenericName=Dungeon simulator
Comment=%{sum}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;RolePlaying;
EOF

# Icon
for size in 48 128 256; do
  install -D -m644 %{_sourcedir}/%{name}-${size}.png %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done

%files
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
