# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Comment next line if not RC version
#define rcv     RC4

%define rel     1

Name:           klog
Version:        2.3.4
Release:        alt1_1
Summary:        An amateur radio logging program
Group:          Communications
License:        GPLv3+
URL:            https://github.com/ea4k/klog
Source0:        https://github.com/ea4k/%{name}/archive/refs/tags/%{version}%{?rcv:-%{rcv}}/%{name}-%{version}%{?rcv:-%{rcv}}.tar.gz
Source1:        klog.desktop

%if ! %{defined rcv}
Patch0:  klog-2.2-fix-install.patch
%endif

BuildRequires:  dos2unix
BuildRequires:  gettext gettext-tools
BuildRequires:  desktop-file-utils
BuildRequires:  ImageMagick-tools libImageMagick7.10
BuildRequires:  kf5-kdeclarative-devel
BuildRequires:  pkgconfig(hamlib)
BuildRequires:  pkgconfig(Qt5Charts)
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Help)
BuildRequires:  pkgconfig(Qt5Location)
BuildRequires:  pkgconfig(Qt5Network)
BuildRequires:  pkgconfig(Qt5Positioning)
BuildRequires:  pkgconfig(Qt5PrintSupport)
BuildRequires:  pkgconfig(Qt5QuickWidgets)
BuildRequires:  pkgconfig(Qt5SerialPort)
BuildRequires:  pkgconfig(Qt5Sql)
# Don't include tests
#BuildRequires:  pkgconfig(Qt5Test)
BuildRequires:  pkgconfig(Qt5Widgets)

Requires:       libqt5-location
Requires:       libqt5-positioning

Requires:     tqsllib trustedqsl
Source44: import.info

%description
KLog is an amateur radio logging program

Some features include:

    * DXCC award support.
    * Basic IOTA support.
    * Importing from Cabrillo files.
    * Importing from TLF.
    * Adding/Editing QSOs.
    * Save/read to/from disk file the log - ADIF format by default.
    * English/Spanish/Portuguese/Galician/Serbian/Swedish support.
    * QSL sent/received support.
    * Read/Write ADIF.
    * Delete QSOs.
    * DX-Cluster support.
    * WSJT-X integration. 
    * Hamlib integration.
    * Export to QRZ.com, LOTW and Clublog.
    * New dark GUI mode since v1.7.
    * New maps feature. 

Some features of this application are still under development.

%prep
%setup -q -n %{name}-%{version}%{?rcv:-%{rcv}}
%if ! %{defined rcv}
%patch0 -p1
%endif


# Remove anti Rusian-Ukranian war splash screen as inapropriate for Magaia's apolitical policy
sed -i 's:mw.showNotWar()::' %{!?rcv: src/}main.cpp

%build
%qmake_qt5 \
         "PREFIX=%{buildroot}%{_prefix}" \
         "CONFIG+=debug c++14" \
         %{!?rcv:src/src.pro}

%make_build

%install
%makeinstall_std

mv %{buildroot}%{_datadir}/%{name}/{COPYING,Changelog} .

# Install the provided desktop icon
for png in 48x48 64x64 128x128 256x256 512x512; do
  mkdir -p %{buildroot}%{_iconsdir}/hicolor/${png}/apps/
  convert -geometry $png %{!?rcv: src/}img/klog_512x512.png %{buildroot}%{_iconsdir}/hicolor/${png}/apps/%{name}.png
done

# Install the provided desktop file
desktop-file-install --dir=%{buildroot}%{_datadir}/applications %{SOURCE1}

%files
%doc Changelog
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_datadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png
%if ! %{defined rcv}
%doc README.md
%{_mandir}/man1/%{name}.1*
%endif


%changelog
