Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%undefine __cmake_in_source_build

Name:           kmetronome
Version:        1.0.1
Release:        alt1_3
License:        GPLv2+
Summary:        A MIDI metronome using the Drumstick library
URL:            http://kmetronome.sourceforge.net
Source:         http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.bz2
BuildRequires:  gcc-c++
BuildRequires:  ctest cmake
BuildRequires:  gettext gettext-tools
BuildRequires:  qt5-base-devel >= 5.1
BuildRequires:  qt5-svg-devel >= 5.1
BuildRequires:  qt5-tools qt5-tools-devel
BuildRequires:  qt5-x11extras-devel >= 5.1
BuildRequires:  drumstick-devel >= 1.0
BuildRequires:  libalsa-devel >= 1.0
BuildRequires:  desktop-file-utils
Source44: import.info

%description
KMetronome is a MIDI metronome with Qt5 interface, based on the Drumstick
library. The intended audience is musicians and music students. Like
solid, real metronomes it is a tool to keep the rhythm while playing musical
instruments. It uses MIDI for sound generation instead of digital audio,
allowing low CPU usage, and very accurate timing thanks to the ALSA sequencer.

%prep
%setup -q

%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

%check
desktop-file-validate $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop

%files
%doc README ChangeLog AUTHORS TODO COPYING NEWS
%{_bindir}/%{name}
%{_datadir}/icons/hicolor/*/apps/%{name}.*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/dbus-1/*/*
%{_datadir}/%{name}/
%{_mandir}/man1/%{name}.1*

%changelog
