# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum     Multiplayer objective-oriented game with knights questing in a dungeon
%define sname   knights

# Using the website's domain name to differentiate this game from KDE games' Knights
Name:           knightsgame
Version:        25
Release:        alt5_25
Summary:        %{sum}
Group:          Games/Arcade
License:        GPLv3+
URL:            https://www.knightsgame.org.uk/
Source0:        https://www.knightsgame.org.uk/files/%{sname}_0%{version}_src.tar.gz
Patch0:		knightsgame-cflags.patch
Patch1:		knightsgame-missing-includes.patch
Patch2:		knightsgame-std.patch
BuildRequires:  boost-complete
BuildRequires:  icoutils icoutils-extra
BuildRequires:  pkgconfig(fontconfig)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(sdl)
Source44: import.info

%description
Knights is a multiplayer game involving several knights who must run
around a dungeon and complete various quests.

Each game revolves around a quest that all players compete to achieve,
such as retrieving some items to carry them back to their starting
point, escaping from the dungeon, fighting a duel to death against
the enemy knights, or destroying an ancient book using a special wand.

%prep
%setup -q -n %{sname}_0%{version}_src
%patch0 -p1
%patch1 -p1
%patch2 -p1


%build
export CXXFLAGS="%{optflags} -pthread -Wno-deprecated-declarations"

%make_build BIN_DIR=%{_gamesbindir} \
      DATA_DIR=%{_gamesdatadir}/%{name} \
      KNIGHTS_BINARY_NAME=%{name} \
      SERVER_BINARY_NAME=%{name}-server

%install
%make_build BIN_DIR=%{buildroot}%{_gamesbindir} \
      DATA_DIR=%{buildroot}%{_gamesdatadir}/%{name} \
      KNIGHTS_BINARY_NAME=%{name} \
      SERVER_BINARY_NAME=%{name}-server \
      install_knights \
      install_server

for size in 16 32 48; do
  mkdir -p %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/
  icotool -x --width=${size} --output=%{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png ./src/icon.ico
done

# Menu entry
mkdir -p %{buildroot}%{_datadir}/applications/
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Knights
Comment=%{sum}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=Game;ArcadeGame;
EOF

%files
%doc docs/ACKNOWLEDGMENTS.txt docs/COPYRIGHT.txt docs/README.txt docs/style.css docs/manual/
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}*
%{_gamesdatadir}/%{name}/client/*
%{_gamesdatadir}/%{name}/server/*
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
