Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global shortcommit 27ecf89
%global commit 27ecf893d093ad88d92ac84fbfc40671cdee0dec
%global snapinfo 20200413git%{shortcommit}

Name:           laby
Version:        0.6.4
Release:        alt3_26.%{snapinfo}
Summary:        Learn programming, playing with ants and spider webs

License:        GPLv3+
URL:            https://sgimenez.github.io/laby/
Source0:        https://github.com/sgimenez/%{name}/archive/%{commit}/%{name}-%{shortcommit}.tar.gz

BuildRequires:  ocaml ocaml-runtime
BuildRequires:  ocaml-findlib-devel
BuildRequires:  ocaml-lablgtk-devel >= 2.14.0
BuildRequires:  ocaml-ocamldoc
BuildRequires:  chrpath
BuildRequires:  libgtksourceview-devel >= 2.10
BuildRequires:  libappstream-glib
BuildRequires:  desktop-file-utils
BuildRequires:  ocaml-ocamlbuild
Source44: import.info

# Note: rpmlint suggest to add
# BuildRequires: python2-devel
# or
# BuildRequires: python3-devel
# but they're not used during the build so they've not been added.

%description
Laby is a small program to learn how to program with ants and spider webs.
You have to move an ant out of a labyrinth, avoid spider webs, move rocks, etc.


%prep
%setup -q -n %{name}-%{commit}

%build
%make_build native

%install
export DESTDIR=%{buildroot}
make install

appstream-util validate-relax --nonet %{buildroot}/%{_datadir}/appdata/*.appdata.xml
desktop-file-validate %{buildroot}/%{_datadir}/applications/%{name}.desktop


%files
%doc --no-dereference COPYRIGHT
%doc --no-dereference gpl-3.0.txt
%doc AUTHORS
%{_bindir}/%{name}
%{_datadir}/%{name}/

# Note above contains also:
# /usr/share/laby/mods/c/lib/robot.h
# /usr/share/laby/mods/cpp/lib/robot.h
# Which rpmlint suggest to have in -devel subpackage.
# This is intentional. The game teach you also how to program in C and in order
# to move the ant, you'll need the robot.h header file. It isn't the use case
# addressed by -devel subpackages.

%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg


%changelog
