Group: Sound
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ladspa-amb-plugins
Version:        0.8.1
Release:        alt2_14
Summary:        Ambisonics LADSPA plugins
License:        GPLv2+
URL:            http://www.kokkinizita.net/linuxaudio/
# Upstream site is down was
# http://www.kokkinizita.net/linuxaudio/downloads/AMB-plugins-%%{version}.tar.bz2
Source:         AMB-plugins-%{version}.tar.bz2
BuildRequires:  gcc-c++
BuildRequires:  ladspa_sdk
Requires:       ladspa_sdk
Obsoletes:      amb-plugins <= 0.0.2
Provides:       amb-plugins = %{version}-%{release}
Source44: import.info

%description
A set of first order Ambisonics plugins to use with Ardour. Included
are: mono and stereo input panner, horizontal rotation, and square and
hexagon horizontal decoders. See the README for more.


%prep
%setup -q -n AMB-plugins-%{version}

sed -i -e "s|/usr/lib/ladspa|\\$\(DESTDIR\)%{_libdir}/ladspa|g" \
    -e "s|-shared|-shared $RPM_LD_FLAGS|g" Makefile

# use the system version of ladspa.h
rm ladspa.h


%build
%make_build CPPFLAGS="-I. -fPIC -D_REENTRANT $RPM_OPT_FLAGS"


%install
mkdir -p %{buildroot}%{_libdir}/ladspa
%makeinstall_std


%files
%doc AUTHORS README
%doc --no-dereference COPYING
%{_libdir}/ladspa/*.so


%changelog
