Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install imake libSM-devel libXt-devel libopenmotif-devel perl(CGI.pm) unzip xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global svn_rev 1200

Name:           lcd4linux
Version:        0.11
# We package an svn snapshot of what will become 0.11 since upstream has
# neglected to do a new release for ages
Release:        alt2_0.32.svn%{svn_rev}
Summary:        Display system state on an external LCD display
License:        GPLv2+
URL:            http://ssl.bulix.org/projects/lcd4linux/
# This is the non rpmbuild parsable url:
# http://ssl.bulix.org/projects/lcd4linux/changeset/1200/trunk?old_path=%2F&format=zip
# Note replace 1200 with svn_rev!
Source0:        lcd4linux-trunk-1200.zip
# Courtesey of Debain
Source1:        lcd4linux.8
Source2:        lcd4X11.sh
Source3:        lcd4X11.desktop
Source4:        README.fedora
Patch0:         lcd4linux-XWindow-conf.patch
BuildRequires:  libgd3-devel libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel libX11-devel libICE-devel libsqlite3-devel
BuildRequires:  serdisplib-devel ftdi-eeprom libftdi1-devel libjpeg-devel libst2205-devel
BuildRequires:  libvncserver-devel gettext-tools libasprintf-devel libdbus-devel
BuildRequires:  libtool desktop-file-utils
# Most drivers require the old libusb-0.1 API; and
# the MDM166A driver requires the new libusb-1.0
BuildRequires:  libusb-compat-devel libusb-devel
ExcludeArch:    s390 s390x
Source44: import.info

%description
LCD4Linux is a small program that grabs information from the kernel
and some subsystems and displays it on an external liquid crystal display.


%prep
%setup -q -n trunk
%patch0 -p1
chmod +x bootstrap configure
./bootstrap
cp -a %{SOURCE4} .


%build
%configure
%make_build
sed -e "s@#Display 'XWindow'@Display 'XWindow'@" \
    -e "s@Display 'ACool'@#Display 'ACool'@" \
    -e "s@Layout 'TestLayer'@#Layout 'TestLayer'@" \
    -e "s@#Layout 'Default'@Layout 'Default'@" \
    lcd4linux.conf.sample > lcd4X11.conf
touch -r lcd4linux.conf.sample lcd4X11.conf


%install
%makeinstall_std
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
mkdir -p $RPM_BUILD_ROOT%{_datadir}/pixmaps
install -p -m 644 lcd4X11.conf $RPM_BUILD_ROOT%{_sysconfdir}
install -p -m 644 lcd4linux.xpm $RPM_BUILD_ROOT%{_datadir}/pixmaps
install -p -m 644 %{SOURCE1} $RPM_BUILD_ROOT%{_mandir}/man8
install -p -m 755 %{SOURCE2} $RPM_BUILD_ROOT%{_bindir}/lcd4X11
desktop-file-install --dir $RPM_BUILD_ROOT%{_datadir}/applications %{SOURCE3}


%files
%doc COPYING ChangeLog README.fedora lcd4linux.conf.sample
%config(noreplace) %{_sysconfdir}/lcd4X11.conf
%{_bindir}/%{name}
%{_bindir}/lcd4X11
%{_mandir}/man8/%{name}.8*
%{_datadir}/pixmaps/%{name}.xpm
%{_datadir}/applications/lcd4X11.desktop


%changelog
