Group: System/Kernel and hardware
BuildRequires: libsgutils-devel
%define oldname ledmon
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Enclosure LED Utilities
Name: ledmon-enclosure
Version: 0.97
Release: alt1_6
License: GPL-2.0-only AND LGPL-2.1-only
URL: https://github.com/intel/ledmon
Source0: https://github.com/intel/ledmon/archive/v%{version}.tar.gz#/%{oldname}-%{version}.tar.gz

# remove -Werror=format-truncation=1 in order to build package
Patch0: ledmon_format-truncation-flag.patch

BuildRequires: libsgutils-devel
BuildRequires: libpci-devel
BuildRequires: autoconf automake
BuildRequires: gcc
# Needed for pkgconfig usage.
BuildRequires: pkgconfig(systemd)
# Needed for the udev dependency.
BuildRequires: libsystemd-devel libudev-devel
BuildRequires: rpm-macros-systemd

Obsoletes: ledctl = 0.1-1
Provides: ledctl = %{version}-%{release}

# https://fedoraproject.org/wiki/Changes/EncourageI686LeafRemoval
ExcludeArch: %{ix86}
Source44: import.info

%description
The ledmon and ledctl are user space applications design to control LED
associated with each slot in an enclosure or a drive bay. There are two
types of system: 2-LED system (Activity LED, Status LED) and 3-LED system
(Activity LED, Locate LED, Fail LED). User must have root privileges to
use this application.

%prep
%setup -n %{oldname}-%{version} -q
%patch0 -p1

autoreconf -fiv

%build
%configure --enable-systemd=yes
%make_build

%install
%makeinstall_std

%post
%post_service ledmon

%preun
%preun_service ledmon

%files
%doc README.md COPYING
%{_sbindir}/ledctl
%{_sbindir}/ledmon
%{_mandir}/*/*
%{_unitdir}/ledmon.service

%changelog
