Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3
# END SourceDeps(oneline)
BuildRequires: libhdf5-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		lhapdf
Version:	6.5.4
Release:	alt2_5
Summary:	Les Houches Accord PDF Interface

License:	GPL-3.0-only
URL:		https://lhapdf.hepforge.org/
Source0:	https://www.hepforge.org/archive/lhapdf/LHAPDF-%{version}.tar.gz
#		Add soname to the shared library, cf. SuSE's spec file.
Patch0:		%{name}-soname.patch

BuildRequires:	gcc-c++
BuildRequires:	python3-module-Cython
%if %{?rhel}%{!?rhel:0} == 7
BuildRequires:	python-devel
%endif
BuildRequires:	python3-devel
%if %{?rhel}%{!?rhel:0} == 7
BuildRequires:	python%{python3_other_pkgversion}-devel
%endif
BuildRequires:	doxygen

#		Obsolete LHAPDF5 packages not provided by LHAPDF6
Obsoletes:	octave-lhapdf < 6
Obsoletes:	lhapdf-pdfsets-minimal < 6
Source44: import.info

%description
LHAPDF is a general purpose C++ interpolator, used for evaluating PDFs
from discretized data files. Previous versions of LHAPDF were written
in Fortran 77/90 and are documented at http://lhapdf.hepforge.org/lhapdf5/.

LHAPDF6 vastly reduces the memory overhead of the Fortran LHAPDF (from
gigabytes to megabytes!), entirely removes restrictions on numbers of
concurrent PDFs, allows access to single PDF members without needing
to load whole sets, and separates a new standardized PDF data format
from the code library so that new PDF sets may be created and released
easier and faster. The C++ LHAPDF6 also permits arbitrary parton
contents via the standard PDG ID code scheme, is computationally more
efficient (particularly if only one or two flavors are required at
each phase space point, as in PDF reweighting), and uses a flexible
metadata system which fixes many fundamental metadata and concurrency
bugs in LHAPDF5.

Compatibility routines are provided as standard for existing C++ and
Fortran codes using the LHAPDF5 and PDFLIB legacy interfaces, so you
can keep using your existing codes. But the new interface is much more
powerful and pleasant to work with, so we think you'll want to switch
once you've used it!

LHAPDF6 is documented in more detail in http://arxiv.org/abs/1412.7420

%package devel
Group: Development/Other
Summary:	Les Houches Accord PDF Interface - development files
Requires:	%{name} = %{version}-%{release}

%description devel
This package provides development files of LHAPDF, including C++ bindings.

%if %{?rhel}%{!?rhel:0} == 7
%package -n python-module-lhapdf
Group: Engineering
Summary:	Les Houches Accord PDF Interface - Python 2 module
%py_provides	python2-%{name}
Requires:	%{name} = %{version}-%{release}

%description -n python-module-lhapdf
This package provides Python 2 bindings for LHAPDF.

This package also provides a script called "lhapdf" which can be used
to query the catalog of PDF sets and to install and update them from
the command line. It accepts commands "list", "update", "install" and
"upgrade". Please run "lhapdf help" for full usage instructions.
%endif

%package -n python3-module-lhapdf
Group: System/Libraries
Summary:	Les Houches Accord PDF Interface - Python 3 module
%py_provides	python3-%{name}
Requires:	%{name} = %{version}-%{release}

%description -n python3-module-lhapdf
This package provides Python 3 bindings for LHAPDF.
%if %{?rhel}%{!?rhel:0} != 7
This package also provides a script called "lhapdf" which can be used
to query the catalog of PDF sets and to install and update them from
the command line. It accepts commands "list", "update", "install" and
"upgrade". Please run "lhapdf help" for full usage instructions.
%endif

%if %{?rhel}%{!?rhel:0} == 7
%package -n python-module-lhapdf
Group: Engineering
Summary:	Les Houches Accord PDF Interface - Python 3 module
%py_provides	python%{python3_other_pkgversion}-%{name}
Requires:	%{name} = %{version}-%{release}

%description -n python-module-lhapdf
This package provides Python 3 bindings for LHAPDF.
%endif

%package doc
Group: Documentation
Summary:	Les Houches Accord PDF Interface - documentation
BuildArch:	noarch

%description doc
This package provides API documentation and examples for LHAPDF.

%prep
%setup -q -n LHAPDF-%{version}
%patch0 -p1

# Remove cython generated file
rm wrappers/python/lhapdf.cpp

%if %{?rhel}%{!?rhel:0} == 7
sed 's!cython!cython%{__python3_version}!' \
    -i wrappers/python/Makefile.am wrappers/python/Makefile.in
%endif

# Fix shebangs
%if %{?rhel}%{!?rhel:0} != 7
sed 's!/usr/bin/env python!%{__python3}!' -i bin/lhapdf examples/*.py
%else
sed 's!/usr/bin/env python!%{__python}!' -i bin/lhapdf examples/*.py
%endif
sed 's!/usr/bin/env bash!/bin/bash!' -i bin/lhapdf-config.in

%build
%configure --disable-static --disable-silent-rules PYTHON=%{__python3} --docdir=%{_docdir}/%{name}
%make_build

%if %{?rhel}%{!?rhel:0} == 7
( cd wrappers/python ; %make_build PYTHON=%{__python} )
( cd wrappers/python ; %make_build PYTHON=%{__python3_other} )
%endif

# Build doxygen documentation
%make_build doxy

%install
%makeinstall_std PYTHON_PATH=%{python3_sitelibdir}

cat << EOF > %{buildroot}%{python3_sitelibdir}/%{name}-%{version}.egg-info
Name: %{name}
Version: %{version}
EOF

%if %{?rhel}%{!?rhel:0} == 7
( cd wrappers/python ; %makeinstall_std PYTHON=%{__python} PYTHON_PATH=%{python_sitelibdir} )
cat << EOF > %{buildroot}%{python_sitelibdir}/%{name}-%{version}.egg-info
Name: %{name}
Version: %{version}
EOF
( cd wrappers/python ; %makeinstall_std PYTHON=%{__python3_other} PYTHON_PATH=%{python3_other_sitearch} )
cat << EOF > %{buildroot}%{python3_other_sitearch}/%{name}-%{version}.egg-info
Name: %{name}
Version: %{version}
EOF
%endif

rm %{buildroot}%{_libdir}/libLHAPDF.la
find %{buildroot}%{_docdir}/%{name}/examples -type f -a '!' -name '*.*' -delete

%check
%make_build check



%files
%{_libdir}/libLHAPDF-%{version}.so
%{_datadir}/LHAPDF
%doc AUTHORS ChangeLog
%doc --no-dereference COPYING

%files devel
%{_bindir}/%{name}-config
%{_includedir}/LHAPDF
%{_libdir}/libLHAPDF.so
%{_libdir}/pkgconfig/%{name}.pc

%if %{?rhel}%{!?rhel:0} == 7
%files -n python-module-lhapdf
%{_bindir}/%{name}
%{python_sitelibdir}/%{name}-%{version}.egg-info
%{python_sitelibdir}/%{name}
%endif

%files -n python3-module-lhapdf
%if %{?rhel}%{!?rhel:0} != 7
%{_bindir}/%{name}
%endif
%{python3_sitelibdir}/%{name}-%{version}.egg-info
%{python3_sitelibdir}/%{name}

%if %{?rhel}%{!?rhel:0} == 7
%files -n python-module-lhapdf
%{python3_other_sitearch}/%{name}-%{version}.egg-info
%{python3_other_sitearch}/%{name}
%endif

%files doc
%doc %{_docdir}/%{name}/doxygen
%doc %{_docdir}/%{name}/examples
%doc --no-dereference COPYING

%changelog
