# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/xsltproc
# END SourceDeps(oneline)
%define oldname gypsy
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%oldname is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name gypsy
%define major		0
%define libname		lib%{oldname}%{major}
%define develname	lib%{oldname}-devel

Name:		libgypsy
Version:	0.9
Release:	alt2_10
Summary:	A GPS multiplexing daemon
Group:		System/Libraries
# See LICENSE file for details
License:	LGPLv2 and GPLv2
URL:		https://gypsy.freedesktop.org/
Source0:	https://gypsy.freedesktop.org/releases/%{oldname}-%{version}.tar.gz
Patch0:		gypsy-0.9-fedora-gtypeinit.patch
Patch1:		gypsy-0.9-mga-no-werror.patch
Patch2:		gypsy-0.9-gcc7.patch
Patch3:		gypsy-0.9-format.patch

BuildRequires:	gtk-doc
BuildRequires:	pkgconfig(bluez)
BuildRequires:	pkgconfig(dbus-1)
BuildRequires:	pkgconfig(dbus-glib-1)
BuildRequires:	pkgconfig(glib-2.0)
BuildRequires:	pkgconfig(gudev-1.0)
BuildRequires:	pkgconfig(libxslt)

Requires:	dbus
Source44: import.info
Provides: gypsy-daemon = %EVR

%description
Gypsy is a GPS multiplexing daemon which allows multiple clients to
access GPS data from multiple GPS sources concurrently.

#--------------------------------------------------------------------

%package -n	%{libname}
Summary:	A GPS multiplexing daemon
Group:		System/Libraries

%description -n %{libname}
A GPS multiplexing daemon

#--------------------------------------------------------------------

%package -n	%{develname}
Summary:	Development package for %{oldname}
Group:		Development/Other
Requires:	%{name} = %{version}-%{release}
Requires:	%{libname} = %{version}-%{release}
Provides:	%{oldname}-devel = %{version}-%{release}
Obsoletes:	gypsy-devel < 0.8-8

%description -n %{develname}
Header files for development with %{oldname}.

#--------------------------------------------------------------------

%package	docs
Summary:	Documentation files for %{oldname}
Group:		Documentation
BuildArch:	noarch
Requires:	%{name} = %{version}-%{release}
Requires:	gtk-doc

%description docs
This package contains developer documentation for %{oldname}.

#--------------------------------------------------------------------

%prep
%setup -n %{oldname}-%{version} -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build
autoreconf -vfi
%configure \
	--disable-static
%make_build

%install
%makeinstall_std

# we don't want these
find %{buildroot} -name '*.la' -delete

%files
%doc AUTHORS COPYING COPYING.lib LICENSE
%{_sysconfdir}/%{oldname}.conf
%{_sysconfdir}/dbus-1/system.d/Gypsy.conf
%{_datadir}/dbus-1/system-services/org.freedesktop.Gypsy.service
%{_libexecdir}/%{oldname}-daemon

%files -n %{libname}
%{_libdir}/libgypsy.so.%{major}
%{_libdir}/libgypsy.so.%{major}.*

%files -n %{develname}
%{_includedir}/%{oldname}/
%{_libdir}/pkgconfig/%{oldname}.pc
%{_libdir}/libgypsy.so

%files docs
%doc %{_datadir}/gtk-doc/html/%{oldname}


%changelog
