%set_verify_elf_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/g++ /usr/bin/perl gcc-c++
# END SourceDeps(oneline)
%add_optflags %optflags_shared
%define fedora 27
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Please void making new releases of the package, because all depending
# packages will be needing rebuilds.

# RPM macro directory

# Commit hash
%global commit 29a6a6df4cd1242c54b5651fc0ac6dd563edf7c0
%global shortcommit %(c=%{commit}; echo ${c:0:7})

# Version of flags used in configure. Increment always when changing the flags, since it will break the API and ABI.
%global apiversion 0

Name:           libint
Version:        1.2.1
Release:        alt1_2
Summary:        A library for computing electron repulsion integrals efficiently
Group:          System/Libraries
# Libint is two things: a code generator, and a generated
# library. This package builds and runs the compiler (GPLv3), and
# builds and ships the generated library (LGPLv3). The license tag
# refers to the binaries, i.e. here the generated library.
License:        LGPLv3
URL:            http://sourceforge.net/p/libint
Source0:        https://github.com/evaleev/libint/archive/%{commit}/libint-%{commit}.tar.gz

# Increase maxnode
Patch1:         libint-1.2.1-maxnode.patch
# Use old-style soname
Patch2:         libint-1.2.1-soname.patch

# Capabilities provided by library
Provides:	libint(api) = %{apiversion}


BuildRequires:  automake
BuildRequires:  autoconf
BuildRequires:  libtool

%if 0%{?rhel} == 6
# Required to build documentation
#BuildRequires:  /usr/bin/bibtex
#BuildRequires:  /usr/bin/pdflatex
%endif

%if 0%{?fedora} > 17 || 0%{?rhel} > 6
# Required to build documentation
BuildRequires:  texlive-latex-recommended texlive-extra-utils
#BuildRequires:  texlive-bibtex
%endif
Source44: import.info

%description
LIBINT computes the Coulomb and exchange integrals, which in electronic
structure theory are called electron repulsion integrals (ERIs). This is by
far the most common type of integrals in molecular structure theory.

LIBINT uses recursive schemes that originate in seminal Obara-Saika method and
Head-Gordon and Poplea.'s variation thereof. The idea of LIBINT is to optimize
computer implementation of such methods by implementing an optimizing compiler
to generate automatically highly-specialized code that runs well on
super-scalar architectures.

%package devel
Summary:  Development headers and libraries for libint
Group:    Development/Other
Requires: libint = %{version}-%{release}
Requires: libderiv = %{version}-%{release}
Requires: libr12 = %{version}-%{release}

%description devel
This package contains development headers and libraries for libint.
It also contains a programmer's manual.

%package -n libr12
Summary:  A library for computing integrals that arise in Kutzelnigga.'s linear R12 theories
Group:    System/Libraries

%description -n libr12
libr12 computes types integrals that appear in Kutzelnigga.'s linear R12 theories
for electronic structure. All linear R12 methods, such as MP2-R12, contain
terms in the wave function that are linear in the inter-electronic distances
r_{ij} (hence the name). Appearance of several types of two-body integrals is
due to the use of the approximate resolution of the identity to reduce three-
and four-body integrals to products of simpler integrals.

%package -n libderiv
Summary:  A library for computing derivatives of electron repulsion integrals
Group:    System/Libraries
Requires: libint = %{version}-%{release}

%description -n libderiv
libderiv computes first and second derivatives of ERIs with respect to the
coordinates of the basis function origin. This type of integrals are also very
common in electronic structure theory, where they appear in analytic gradient
expressions. The derivatives are typically used in the calculation of forces.


%prep
%setup -q -n %{name}-%{commit}
%patch1 -p1 -b .maxnode
%patch2 -p1 -b .soname
libtoolize --copy --force
aclocal -I lib/autoconf
autoconf

%build
# Disable stack size limit due to static allocation of arrays
ulimit -s unlimited
%configure --enable-shared --disable-static \
 --with-libint-max-am=10 --with-libint-opt-am=6 \
 --with-libderiv-max-am1=6 --with-libderiv-max-am2=5 \
 --with-libr12-max-am=5 --with-libr12-opt-am=4

# The generated library is already highly optimized for performance,
# so it's safe to use a lower level of compiler optimization here.
oflags=`echo %{optflags} | sed "s|-O2|-O1|g"`
make CFLAGS="${oflags}" CXXFLAGS="${oflags}" %{?_smp_mflags}

# Build documentation
cd doc/progman
pdflatex progman
bibtex progman
pdflatex progman
pdflatex progman


%install
make install DESTDIR=%{buildroot}
find %{buildroot} -name *.la -delete
find %{buildroot} -name *.so.*.* -exec chmod 755 {} \;

# Create macro file
mkdir -p %{buildroot}%{_rpmmacrosdir}
cat > %{buildroot}%{_rpmmacrosdir}/libint << EOF
# Current version of libint is
%%_libint_apiversion %%{apiversion}
EOF

%files
%doc LICENSE COPYING COPYING.LESSER
%{_libdir}/libint*.so.*

%files -n libderiv
%doc LICENSE COPYING COPYING.LESSER
%{_libdir}/libderiv*.so.*

%files -n libr12
%doc LICENSE COPYING COPYING.LESSER
%{_libdir}/libr12*.so.*

%files devel
%doc doc/progman/progman.pdf
%{_rpmmacrosdir}/libint
%{_includedir}/libint/
%{_includedir}/libderiv/
%{_includedir}/libr12/
%{_libdir}/*.so


%changelog
