# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/git gcc-c++ unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname libjson-rpc-cpp

%define jsoncpp_major 0
%define libname libjsonrpccpp%{jsoncpp_major}
%define develname libjsonrpccpp0.6-devel

Name:       libjson-rpc-cpp0.6
Version:    0.6.0
Release:    alt2_5
Summary:    C++ JSON Library
License:    Public Domain
Group:      System/Libraries
Url:        http://jsoncpp.sourceforge.net/
Source0:    %{oname}-%{version}.zip
Patch0:	    libjson-rpc-cpp-0.6.0-gcc.patch
Patch1:     libjson-rpc-cpp-0.6.0-cmake.patch
#To generate docs
BuildRequires: 	ccmake cmake ctest
BuildRequires: 	libcurl-devel
BuildRequires: 	pkgconfig(libmicrohttpd)
BuildRequires:	jsoncpp-devel
BuildRequires:	libargtable2-devel
Source44: import.info

%description
JsonCpp is a simple API to manipulate JSON value, handle serialization
and unserialization to string.

%package -n %libname
Summary:        JsonCpp library
Group:          System/Libraries
Obsoletes:      %{_lib}libjson-rpc-cpp0 < 0.6.0-3

%description -n %libname
This framework provides cross platform JSON-RPC (remote procedure call)
support for C++. It is fully JSON-RPC 2.0 & 1.0 compatible.

%package -n     %{develname}
Summary:        Development files for %{name}
Group:          Development/C++
Requires:       %{libname} = %{version}-%{release}
Provides:       json-rpc-cpp0.6-devel = %{version}-%{release}
Provides:       libjson-rpc-cpp0.6-devel = %{version}-%{release}
Obsoletes:      %{_lib}libjson-rpc-cpp-devel < 0.6.0-3
Conflicts:      libjsonrpccpp-devel >= 1.0.0

%description -n    %{develname}
It can also preserve existing comment in unserialization/serialization steps,
making it a convenient format to store user input files.

Files for building applications with %{name} support.

%prep
%setup -qn %{oname}-%{version}
%patch0 -p0
%patch1 -p0

%build
%{mageia_cmake} \
  -DCOMPILE_TESTS=NO \
  -DCOMPILE_STUBGEN=NO \
  -DCATCH_INCLUDE_DIR=%{_includedir}/catch \
  -DFULL_PATH_LIBDIR=%{_libdir} \
  -DFULL_PATH_INCLUDEDIR=%{_includedir}
%mageia_cmake_build

%install
%mageia_cmake_install

%files -n %libname
%{_libdir}/libjsonrpccpp-*.so.%{jsoncpp_major}
%{_libdir}/libjsonrpccpp-*.so.%{jsoncpp_major}.*

%files -n %develname
%doc AUTHORS.md CHANGELOG.md LICENSE.txt README.md
%{_includedir}/jsonrpccpp/
%{_libdir}/libjsonrpccpp-*.so
%{_libdir}/pkgconfig/*.pc


%changelog
