# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
BuildRequires: gcc-c++ libdmalloc-devel python-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{!?python_sitearch: %define python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

Name:           librapi
Version:        0.15.2
Release:        alt2_16
Summary:        Library to connect to Pocket PC devices

Group:          System/Libraries
License:        MIT
URL:            http://www.synce.org
Source0:        http://download.sf.net/synce/librapi2-%{version}.tar.gz
Patch0:         librapi2-dso.patch

BuildRequires:  libsynce-devel >= 0.15.1
BuildRequires:  python-module-Pyrex
BuildRequires:  libdbus-devel libdbus-glib-devel
BuildRequires:  libudev-devel
BuildRequires:  libtool

# Provide an upgrade path from the monilithic synce package
Provides:       synce = %{version}-%{release}
Obsoletes:      synce <= 0.9.1-10
Source44: import.info

%description
The RAPI library is an open source implementation that works like RAPI.DLL,
available on Microsoft operating systems. The library makes it possible to make
remote calls to a computer running Pocket PC.
In order to use librapi, a daemon that the Pocket PC client connects to must be
running on the computer using librapi.

%package devel
Summary: Development libraries and header files for librapi
Group: Development/Other
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
This package contains the header files and link libraries for librapi

%package -n python-module-rapi
%{?python_provide:%python_provide python2-rapi}
Summary: Python bindings to librapi (part of SynCE)
Group: Development/Other
Requires: %{name} = %{version}-%{release}

%description -n python-module-rapi
This package contains the python bindings to librapi, a component
of the SynCE PocketPC connection framework.
The python module to import is named "pyrapi2"


%prep
%setup -q -n librapi2-%{version}
%patch0

# Prevent configure from killing CFLAGS
sed -i -e 's,^\(CFLAGS=\"\"\),#\1,' configure*
# Fix up timestamps to avoid re-running autotools
touch -r aclocal.m4 configure*

%build
%configure \
--disable-hal-support \
--enable-udev-support \
--disable-static --disable-rpath
make LIBTOOL=/usr/bin/libtool %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT

rm -f $RPM_BUILD_ROOT%{_libdir}/*.{la,a}
rm -f $RPM_BUILD_ROOT%{python_sitelibdir}/pyrapi2.{la,a}

%files
%doc BUGS ChangeLog README README.contributing TODO
%{_bindir}/*
%{_libdir}/librapi.so.2*
%{_mandir}/man1/*

%files devel
%doc README.design
%{_includedir}/*.h
%{_libdir}/lib*.so
%{_libdir}/pkgconfig/*.pc
%{_mandir}/man3/*

%files -n python-module-rapi
%{python_sitelibdir}/pyrapi2.so


%changelog
