# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-build-python3 rpm-build-ruby rpm-macros-mageia-compat
BuildRequires: /usr/bin/doxygen boost-devel gcc-c++ jsoncpp-devel libmicrohttpd-devel libruby-devel libtinfo-devel perl(Net/Twitter.pm) perl-podlators pkgconfig(libgvc) pkgconfig(libyui) python3-devel
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define major     16
%define libname   libyui%{major}
%define develname libyui-devel

#--------------------------------------------------------
# Package libyui-ncurses
%define yui_ncurses_name libyui-ncurses

%define libncurses libyui-ncurses%{major}
%define devncurses libyui-ncurses-devel
#--------------------------------------------------------
# Package libyui-qt
%define yui_qt_name libyui-qt

%define libqt libyui-qt%{major}
%define devqt libyui-qt-devel
#--------------------------------------------------------

# bootstrap build with/without libyui-mga
# without = with libyui-mga
# with = without libyui-mga
%bcond_without mga

Name:           libyui
Version:        4.4.4
Release:        alt1_3
Summary:        YaST2 User Interface Engine
Group:          System/Libraries
License:        LGPLv2+
URL:            https://github.com/libyui/libyui
Source0:        https://github.com/libyui/libyui/archive/%{version}/%{name}-%{version}.tar.bz2

BuildRequires:  ccmake cmake ctest
BuildRequires:  boost-complete
BuildRequires:  libtool
BuildRequires:  perl-devel
BuildRequires:  pkgconfig(ruby)
BuildRequires:  gem
BuildRequires:  swig
BuildRequires:  pkgconfig(python3)

BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Svg)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  pkgconfig(Qt5X11Extras)

BuildRequires: pkgconfig(ncursesw)
BuildRequires: pkgconfig(ncurses)

%if %{with mga}
BuildRequires:  pkgconfig(libyui-mga)
%endif
Source44: import.info

%description
libYUI is a library written entirely in C++ to provide an abstraction layer for
Qt, GTK and ncurses UI frameworks. This means that a single code in YUI can be
used to produce outputs using any of the 3 UI frameworks listed above. This
library was (and still is) used to create the YaST2 User Interface.

#----------------------------------------------------------
# libyui

%package -n %libname
Summary:      YaST2 User Interface Engine
Group:        System/Libraries
Provides:     %{name} = %{version}-%{release}
Provides:     %{name} = %{version}-%{release}
Provides:     %{name}%{major} = %{version}-%{release}
Provides:     %{name}%{major} = %{version}-%{release}
Obsoletes:    %{_lib}yui15 < 4.2.17

%description -n %libname
This package contains the library needed to run programs dynamically linked
with libyui.

%files -n %libname
%doc COPYING* README.md
%dir %{_libdir}/yui
%dir %{_datadir}/libyui
%{_libdir}/libyui.so.%{major}
%{_libdir}/libyui.so.%{major}.*


#----------------------------------------------------------
# libyui-devel

%package -n %develname
Summary:      libYUI, YaST2 User Interface Engine - header files
Group:        Development/C++
Requires:     %{libname} >= %{version}
Requires:     boost-complete
Provides:     %{name}-devel = %{version}-%{release}
Provides:     yui-devel = %{version}-%{release}

%description -n %develname
This is the development package for libyui user interface engine that provides
the abstraction from graphical user interfaces (Qt, Gtk) and text based user
interfaces (ncurses).

%files -n %develname
%{_libdir}/libyui.so
%{_libdir}/pkgconfig/libyui.pc
%{_includedir}/yui/*.h
%{_datadir}/libyui/buildtools

#-----------------------------------------------------------------------
# libyui-qt

%package -n %libqt
Summary:        Libyui - Qt (graphical) user interface
Group:          System/Libraries
Requires:       libqt5-x11extras
Provides:       %{yui_qt_name} = %{version}-%{release}
Provides:       %{yui_qt_name} = %{version}-%{release}
Provides:       %{yui_qt_name}%{major} = %{version}-%{release}
Provides:       %{yui_qt_name}%{major} = %{version}-%{release}
Obsoletes:      %{_lib}yui15-qt < 4.2.17

%description -n %libqt
This package contains the Qt (graphical) user interface component for libyui.

%files -n %libqt
%doc COPYING*
%{_libdir}/yui/libyui-qt.so.%{major}
%{_libdir}/yui/libyui-qt.so.%{major}.*

#-----------------------------------------------------------------------
# libyui-qt-devel

%package -n %devqt
Summary:        Libyui - Qt (graphical) user interface header files
Group:          Development/KDE and QT
Requires:       %{yui_qt_name} = %{version}-%{release}
Provides:       yui-qt-devel = %{version}-%{release}

%description -n %devqt
This package contains the header files for the Qt based user interface
component for libyui.

This package is not needed to develop libyui-based applications, only to
develop extensions for libyui-qt.

%files -n %devqt
%{_includedir}/yui/qt
%{_libdir}/yui/libyui-qt*.so
%{_libdir}/pkgconfig/libyui-qt.pc

%if 0
#-----------------------------------------------------------------------
# libyui-ncurses

%package -n %libncurses
Summary:        Libyui - NCurses (text based) user interface
Group:          System/Libraries
Provides:       %{yui_ncurses_name} = %{version}-%{release}
Provides:       %{yui_ncurses_name} = %{version}-%{release}
Provides:       %{yui_ncurses_name}%{major} = %{version}-%{release}
Provides:       %{yui_ncurses_name}%{major} = %{version}-%{release}
Obsoletes:      %{_lib}yui15-ncurses < 4.2.17

%description -n %libncurses
This package contains the NCurses (text based) user interface component for
libyui.

%files -n %libncurses
%doc COPYING*
%{_libdir}/yui/libyui-ncurses.so.%{major}
%{_libdir}/yui/libyui-ncurses.so.%{major}.*

#-----------------------------------------------------------------------
# libyui-ncurses-devel

%package -n %devncurses
Summary:        Libyui - Header files for the NCurses (text based) user interface
Group:          Development/Other
Requires:       %{yui_ncurses_name} = %{version}-%{release}
Provides:       yui-ncurses-devel = %{version}-%{release}

%description -n %devncurses
This package contains the header files for the NCurses (text based) user
interface component for libyui.

This package is not needed to develop libyui-based applications, only to
develop extensions for libyui-ncurses.

%files -n %devncurses
%{_libdir}/yui/libyui-ncurses*.so
%{_includedir}/yui/ncurses
%{_libdir}/pkgconfig/libyui-ncurses.pc


#----------------------------------------------------------
# libyui-ncurses-tools

%package -n %{yui_ncurses_name}-tools

Summary:        Libyui - tools for the NCurses (text based) user interface
Group:          System/Libraries
Requires:       screen

%description -n %{yui_ncurses_name}-tools
This package contains tools for the NCurses (text based) user interface
component for libyui:

libyui-terminal - useful for testing on headless machines

%files -n %{yui_ncurses_name}-tools
%{_bindir}/libyui-terminal

#----------------------------------------------------------
# ruby-yui

%package -n ruby-yui
License:        GPLv2+
Summary:        Ruby bindings for libyui
Group:          Development/Ruby

%description -n ruby-yui
This package provides Ruby language bindings to access functions of libyui, the
YaST User Interface engine that provides the abstraction from graphical user
interfaces (Qt, Gtk) and text based user interfaces (ncurses).

%files -n ruby-yui
%doc libyui-bindings/swig/ruby/examples/*.rb
%{ruby_sitearchdir}/_yui.so

#----------------------------------------------------------
# python3-yui

%package -n python3-module-yui
License:        GPLv2+
Summary:        Python 3 bindings for libyui
Group:          Development/Python
%{?python_provide:%python_provide python3-yui}

%description -n python3-module-yui
This package provides Python 3 language bindings to access functions of libyui,
the YaST User Interface engine that provides the abstraction from graphical
user interfaces (Qt, Gtk) and text based user interfaces (ncurses).

%files -n python3-module-yui
%doc libyui-bindings/swig/python/examples/*.py
%{python3_sitelibdir}/_yui.so
%{python3_sitelibdir}/yui.*
%{python3_sitelibdir}/__pycache__/*

#----------------------------------------------------------
# perl-yui

%package -n perl-yui
License:        GPLv2+
Summary:        Perl bindings for libyui
Group:          Development/Perl

%description -n perl-yui
This package provides Perl language bindings to access functions of libyui, the
YaST User Interface engine that provides the abstraction from graphical user
interfaces (Qt, Gtk) and text based user interfaces (ncurses).

%files -n perl-yui
%doc libyui-bindings/swig/perl/examples/*.pl
%{perl_vendor_archlib}/yui.so
%{perl_vendor_archlib}/yui.pm

#----------------------------------------------------------
%endif

%prep
%setup -q -n %{name}-%{version}


%build
# Let's pass cmake definitions to all the project to simplify building in a loop
#for pkgname in libyui libyui-qt libyui-ncurses libyui-bindings ;do
for pkgname in libyui libyui-qt ;do
  pushd $pkgname

  %{mageia_cmake} \
      -DBUILD_EXAMPLES=OFF \
      -DWITH_MGA=%{?with_mga:ON}%{!?with_mga:OFF} \
      -DWITH_MONO=OFF \
      -DPYTHON_EXECUTABLE=/usr/bin/python3 \
      -DPYTHON_INCLUDE_DIR=%{_includedir}/python%{__python3_version} \
      -DPYTHON_SITEDIR=%{python3_sitelibdir} \
      -DPYTHON_LIB_DIR=%{python3_sitelibdir_noarch} \
      -DWERROR=off

  %mageia_cmake_build

  popd
done

%install

#for pkgname in libyui libyui-qt libyui-ncurses libyui-bindings ;do
for pkgname in libyui libyui-qt ;do
  pushd $pkgname
  %mageia_cmake_install
  popd
done

install -m0755 -d %{buildroot}%{_libdir}/yui


%changelog
