# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define         major        16
%define         libname      libyui-mga%{major}
%define         develname    libyui-mga-devel

Name:           libyui-mga
Version:        1.2.1
Release:        alt1_5
Summary:        UI abstraction library - Mageia extension widget base plugin
License:        LGPLv2+
Group:          System/Libraries
Url:            https://github.com/manatools/libyui-mga
Source0:        https://github.com/manatools/libyui-mga/archive/%{version}/%{name}-%{version}.tar.gz

BuildRequires:    pkgconfig(libpng)
BuildRequires:    pkgconfig(libyui)
BuildRequires:    ccmake cmake ctest
BuildRequires:    boost-complete
BuildRequires:    ghostscript
BuildRequires:    graphviz
Source44: import.info

%description
%{summary}

#-----------------------------------------------------------------------

%package -n %libname
Summary:        %{summary}
Group:          System/Libraries
Requires:       libyui
Provides:       %{name} = %{version}-%{release}
Provides:       %{name} = %{version}-%{release}
Provides:       %{name}%{major} = %{version}-%{release}
Provides:       %{name}%{major} = %{version}-%{release}
Obsoletes:	%{_lib}yui15-mga < 1.2.1-3

%description -n %libname
This package contains the library needed to run programs
dynamically linked with libyui-mga.

%files -n %libname
%doc COPYING*
%{_libdir}/libyui-mga.so.%{major}
%{_libdir}/libyui-mga.so.%{major}.*

#-----------------------------------------------------------------------

%package -n %develname
Summary:        %{summary} header files
Group:          Development/C++
Requires:       %{libname} = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}
Provides:       yui-mga-devel = %{version}-%{release}

%description -n %develname
This package provides headers files for libyui-mga development.

%files -n %develname
%{_includedir}/yui
%{_libdir}/libyui-mga.so
%{_libdir}/pkgconfig/libyui-mga.pc

#-----------------------------------------------------------------------

%prep
%setup -q


%build
%{mageia_cmake} \
    -DBUILD_EXAMPLES=NO
%mageia_cmake_build

%install
%mageia_cmake_install


%changelog
