# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: boost-devel boost-filesystem-devel gcc-c++ qt5-base-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define         major        16
%define         libname      libyui-mga-qt%{major}
%define         develname    libyui-mga-qt-devel

Name:           libyui-mga-qt
Version:        1.2.0
Release:        alt1_3
Summary:        UI abstraction library - Qt plugin
License:        LGPLv2+
Group:          System/Libraries
Url:            https://github.com/manatools/libyui-mga-qt
Source0:        https://github.com/manatools/libyui-mga-qt/archive/%{name}-%{version}.tar.gz
Patch0:         00_libyui-qt-dep.patch

BuildRequires:    pkgconfig(libpng)
BuildRequires:    pkgconfig(libyui)
BuildRequires:    pkgconfig(libyui-qt)
BuildRequires:    pkgconfig(libyui-mga)
# TODO Check ...
BuildRequires:    pkgconfig(Qt5X11Extras)
BuildRequires:    pkgconfig(Qt5Svg)
# ... TODO Check
BuildRequires:    ccmake cmake ctest
BuildRequires:    boost-complete

BuildRequires:    ghostscript
BuildRequires:    graphviz
BuildRequires:    pkgconfig(fontconfig)
Source44: import.info

%description
%{summary}.

#-----------------------------------------------------------------------

%package -n %libname
Summary:        %{summary}
Group:          System/Libraries
Provides:       %{name} = %{version}-%{release}
Provides:       %{name} = %{version}-%{release}
Provides:       %{name}%{major} = %{version}-%{release}
Provides:       %{name}%{major} = %{version}-%{release}

%description -n %libname
This package contains the library needed to run programs
dynamically linked with libyui-mga-qt.

%files -n %libname
%doc COPYING*
%{_libdir}/yui/libyui-mga-qt.so.%{major}
%{_libdir}/yui/libyui-mga-qt.so.%{major}.*


#-----------------------------------------------------------------------

%package -n %develname
Summary:        %{summary} header files
Group:          Development/KDE and QT
Requires:       %{name} = %{version}-%{release}
Provides:       yui-mga-qt-devel = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}

%description -n %develname
This package provides headers files for libyui-mga-qt development.

%files -n %develname
%{_includedir}/yui/mga/qt/
%{_libdir}/yui/libyui-mga-qt.so

#-----------------------------------------------------------------------

%prep
%setup -q
%patch0 -p1


%build
%{mageia_cmake} \
       -DCMAKE_SKIP_INSTALL_RPATH:BOOL=no \
       -DCMAKE_INSTALL_RPATH:PATH=%{_libdir}/yui
%mageia_cmake_build

%install
%mageia_cmake_install


%changelog
