Group: Graphical desktop/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Review at https://bugzilla.redhat.com/show_bug.cgi?id=496167

# %%global prerelease

Name:           lilyterm
Version:        0.9.9.2
Release:        alt2_22%{?prerelease:.%{?prerelease}}
Summary:        Light and easy to use X Terminal Emulator

License:        GPLv3+
URL:            http://lilyterm.luna.com.tw
Source0:        http://lilyterm.luna.com.tw/file/lilyterm-%{version}%{?prerelease:~%{?prerelease}}.tar.gz

BuildRequires:  gcc
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:  libvte-devel vte
BuildRequires:  desktop-file-utils intltool
Source44: import.info

%description
LilyTerm is a light and easy to use libvte based X Terminal Emulator with a 
lot of features:
 * Supports multiple tabs, reorderable tabs and hides the tab tray when there 
   is only one tab
 * Add, close, swith, move, rename tabs with function keys
 * Disable/Enable function keys for temporary (use <Ctrl><`> by default).
 * Shows the foreground running command on tab and/or window title.
 * Change the font name, size, and window size with right click menu.
 * User custom function keys (need to edit profile).
 * Support for User/System profiles.
 * Supports true transparency if the window manager is composited.
 * Support for transparent background and background saturation.
 * Support for text and background color (need to edit profile).
 * Good support for UTF-8.
 * Decide the text encoding via environment. Using UTF-8 by default.
 * Change the text encoding with right click menu.


%prep
%setup -qn lilyterm-%{version}%{?prerelease:~%{?prerelease}}


%build
#export NOCONFIGURE=yes
#sh autogen.sh
%configure

# parallel make breaks with "Text file busy"
#make %{?_smp_mflags}
make

%install
make install DESTDIR=$RPM_BUILD_ROOT
desktop-file-install                                       \
  --delete-original                                        \
  --remove-category=Utility                                \
  --add-category=System                                    \
  --dir=${RPM_BUILD_ROOT}%{_datadir}/applications          \
  ${RPM_BUILD_ROOT}%{_datadir}/applications/%{name}.desktop
%find_lang %{name}
# we install the docfiles versioned
rm -rf ${RPM_BUILD_ROOT}%{_datadir}/doc/lilyterm/



%files -f %{name}.lang
%doc --no-dereference COPYING
%doc AUTHORS ChangeLog README TODO
%config(noreplace) %{_sysconfdir}/lilyterm.conf
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/lilyterm.*
%{_mandir}/man*/%{name}.*.*


%changelog
