Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           linpsk
Version:        1.3.5
Release:        alt2_16
Summary:        Psk31 and RTTY program for Linux

License:        GPLv2+
URL:            http://linpsk.sourceforge.net/
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
# Add .desktop file
Source1:        %{name}.desktop
# Install wrapper
Source2:        %{name}.sh.in
# Hi-res icon, rhbz#1157554
Source3:        %{name}_64x64.png

# Patch asoundrc file for default sound card (device 0)
Patch0:         linpsk-1.1-3.sound.conf.patch
Patch1:         linpsk-comparison.patch


BuildRequires:  libfftw3-devel
BuildRequires:  libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools
BuildRequires:  libalsa-devel
BuildRequires:  desktop-file-utils
Source44: import.info

#Requires:

# Spelling error in desc. is intentional. Hobby jargon ignore rpmlint warnings.
%description
LinPsk is a program for operating on digital modes running on Linux.
LinPsk supports BPSK, QPSK and RTTY at the moment.
Main features are:
* the simultaneous decoding of up to four channels.
* The different digital modes may be mixed
* You can define a trigger on each channel to be notified if a text of your
  choice is detected.
* You can log each received channel at a file.
* For easy qso'ing you can define macros and for larger texts to be send you
  can use two files.
* You can view the signal as spectrum or in a waterfall display. Both are
  scale-able in the frequency domain.
At the Moment RTTY only supports 45 baud and 1.5 stop-bits.

%prep
%setup -q

#fix permissions for debuginfo files
chmod 0644 src/{rttydemodulator.cpp,rttydemodulator.h}

%patch0 -p1 -b 3.sound.conf
%patch1 -p1 -b comparison

%build
%{qmake_qt4} -unix -o Makefile %{name}.pro
%make_build CFLAGS="$RPM_OPT_FLAGS"

%install
mkdir -p %{buildroot}%{_bindir}

# Move original binary to libexecdir
mkdir -p %{buildroot}/%{_libexecdir}/
install -m 755 %{name} %{buildroot}%{_libexecdir}/%{name}-bin

# Install wrapper script
install -p -D -m 0755 %{SOURCE2} %{buildroot}/%{_bindir}/%{name}

# Install default sound configuration file
mkdir -p %{buildroot}/%{_sysconfdir}/skel/.%{name}/
install -p -D -m 0644 asoundrc %{buildroot}/%{_sysconfdir}/skel/.%{name}/asoundrc

# Install provided icon
mkdir -p %{buildroot}%{_datadir}/pixmaps/
cp %{SOURCE3} %{buildroot}%{_datadir}/pixmaps/%{name}.png
# no upstream .desktop
desktop-file-install \
        --dir=%{buildroot}%{_datadir}/applications %{SOURCE1}
# --vendor obsolete per new guidlines but leaving it in because
# this is an existing package with vendor previously installed

#Remove development files
find %{buildroot} -type f -name "*.a" -exec rm -f {} ';'

%files
%doc COPYING ChangeLog README
%{_bindir}/%{name}
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/applications/*%{name}.desktop
%config(noreplace) %{_sysconfdir}/skel/.%{name}/asoundrc
%{_libexecdir}/%{name}-bin

%changelog
