Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate libXcursor-devel libXfixes-devel libXinerama-devel libjpeg-devel
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           linsim
Version:        2.0.4
Release:        alt1_6
Summary:        Tool for Amateur Radio Digital Mode evaluation

License:        GPLv3+
URL:            http://www.w1hkj.com
Source0:        http://www.w1hkj.com/files/test_suite/%{name}-%{version}.tar.gz
Source99:       linsim.appdata.xml

Patch0:         linsim-desktop.patch

# Utils
BuildRequires:  gcc-c++
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  desktop-file-utils
# Build dependencies
BuildRequires:  libfltk-devel >= 1.3.4
BuildRequires:  libsamplerate-devel
BuildRequires:  libsndfile-devel
BuildRequires:  libpng-devel libpng17-tools
BuildRequires:  libXft-devel
Source44: import.info


%description
Linsim is designed to read and then add path simulation to any monophonic wav
file recorded at any sampling rate. It works particularly well with files that
were created using fldigia.'s audio capture and audio generate functions. The
entire wav file will be saved to computer memory and then duplicated during the
signal processing. The user should try to keep the length of the wav file at 20
Mg or less, but the author has tested some 200 Mg files on both Linux and
Windows-8 without causing a program fault. These files were original VOAR
broadcasts of about 30 minutes duration. The objective of this type of
simulation is to finally measure the character error rate (CER) and bit error
rate (BER) of a specific modem type and decoder design. For most modems a
sequence of 1000 characters provides a sufficient level of confidence in the
CER measurment.


%prep
%setup -q
%patch0 -p1



%build
# Work around fltk-devel bug in RHEL 7.
# https://bugzilla.redhat.com/show_bug.cgi?id=1510482
export LIBS="-lfltk"
%configure
%make_build


%install
%makeinstall_std

%if 0%{?fedora}
# Install appdata file
mkdir -p %{buildroot}%{_datadir}/metainfo
install -pm 0644 %{SOURCE99} %{buildroot}%{_datadir}/metainfo/
%endif


%check
desktop-file-validate %{buildroot}/%{_datadir}/applications/%{name}.desktop
%if 0%{?fedora}
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/metainfo/*.appdata.xml
%endif


%files
%doc --no-dereference COPYING
%doc AUTHORS ChangeLog README
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{?fedora:%{_datadir}/metainfo/%{name}.appdata.xml}
%{_datadir}/pixmaps/%{name}.xpm



%changelog
