Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/glib-gettextize gcc-c++ pkgconfig(cairo) pkgconfig(gtk+-2.0) pkgconfig(libxml-2.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 7

Name:           linsmith
Version:        0.99.33
Release:        alt1_%autorelease
Summary:        A Smith charting program
License:        GPLv2
URL:            http://jcoppens.com/soft/linsmith/index.en.php
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
BuildRequires:  desktop-file-utils
BuildRequires:  gcc
BuildRequires:  gettext-tools
BuildRequires:  libgnomeui-devel
Requires:       libtcl tcl
Source44: import.info

%description
linSmith is a Smith Charting program.
It's main features are:
  * Definition of multiple load impedances
  * Addition of discrete and line components
  * A 'virtual' component switches from impedance
    to admittance to help explaining parallel components
  * The chart works in real impedances
  * Load and circuit configuration is stored separately,
    permitting several solutions without re-defining the other

%prep
%setup -q


%build
# Build in C89 mode due to many implicit function declarations.
%global build_type_safety_c 0

CC="$CC -std=gnu89"
export CPPFLAGS="$CPPFLAGS -fcommon"
%configure
%make_build


%install
%makeinstall_std

desktop-file-install \
    --dir=%{buildroot}/%{_datadir}/applications \
    --delete-original                           \
    --remove-category GTK                       \
    --remove-category GNOME                     \
    --add-category "Electronics"                \
    %{_builddir}/%{name}-%{version}/%{name}.desktop

# icon
cp -p linsmith_icon.xpm %{buildroot}/%{_datadir}/pixmaps/%{name}/

# man file
mkdir -p %{buildroot}/%{_datadir}/man/man1
cp -p doc/linsmith.1 %{buildroot}/%{_datadir}/man/man1

#examples
mv %{buildroot}/%{_datadir}/%{name} examples/

%find_lang %{name}


%files -f %{name}.lang
%doc AUTHORS ChangeLog NEWS README THANKS doc/manual.pdf examples/*
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_datadir}/applications/*%{name}.desktop
%{_datadir}/pixmaps/%{name}
%{_mandir}/man1/%{name}.1*


%changelog
