# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define upname loki
%define majorversion 0
Name: %{upname}-lib
Version: 0.1.7
Release: alt1_13
Summary: Loki C++ Library of design patterns and idioms

Group: Development/C
License: MIT
# License text not included
# https://sourceforge.net/tracker/?func=detail&aid=3027570&group_id=29557&atid=396647
URL: http://sourceforge.net/projects/loki-lib
Source0: http://prdownloads.sourceforge.net/loki-lib/%{upname}-%{version}.tar.gz
Source44: import.info


%description
A C++ library of designs, containing flexible implementations of common design
patterns and idioms.

%package devel
Summary: The Loki C++ headers and development libraries
Group: Development/C
Requires: %{name}%{?_isa} = %{version}-%{release}
%description devel
Headers and shared object symlinks for the Loki C++ Library

%package doc
Summary: The Loki C++ html docs
Group: Documentation
BuildArch: noarch
%description doc
HTML documentation files for the Loki C++ Library

%prep
%setup -n %{upname}-%{version} -q
chmod -x doc/html/*
rm doc/html/installdox
iconv -f ISO88591 -t utf8 CHANGES -o CHANGES

%build
make %{?_smp_mflags} CXXFLAGS="%{optflags}" build-static build-shared
(cd lib && ln -s lib%{upname}.so.%{version} lib%{upname}.so)
(cd lib && ln -s lib%{upname}.so.%{version} lib%{upname}.so.%{majorversion})

%install
make %{?_smp_mflags} -C include prefix=%{buildroot}%{_usr} install
mkdir -p %{buildroot}%{_libdir}
cp -a lib/lib%{upname}.* %{buildroot}%{_libdir}

%check
make %{?_smp_mflags} CXXFLAGS="%{optflags}" check

%files
%doc README
%{_libdir}/*.so.*

%files devel
%doc CHANGES
%{_includedir}/*
%{_libdir}/*.so
%exclude %{_libdir}/*.a

%files doc
%doc doc/html doc/flex doc/yasli

%changelog
