Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           lshell
Version:        0.9.18
Release:        alt1_8
Summary:        A Python-based limited shell

License:        GPLv3+
URL:            https://github.com/ghantoos/lshell
Source0:        https://github.com/ghantoos/lshell/releases/download/%{version}/%{name}_%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  python3-devel
Requires(pre):  shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Source44: import.info

%description
lshell provides a limited shell configured per user. The configuration
is done quite simply using a configuration file.

%prep
%setup -q
#Fix permission
chmod -x CHANGES

%build
%python3_build

%install
%python3_install
# Doc files at the wrong place
rm %{buildroot}%{_defaultdocdir}/lshell/{CHANGES,COPYING,README.md}

%pre
getent group lshell >/dev/null || groupadd -r lshell

%post
grep -q '^%{_bindir}/%{name}$' %{_sysconfdir}/shells || \
    echo '%{_bindir}/%{name}' >> %{_sysconfdir}/shells

%postun
if [ $1 -eq 0 ]; then
    sed -i '/^\/%{_bindir}\/%{name}$/d' %{_sysconfdir}/shells
fi

%files
%doc CHANGES README.md
%doc --no-dereference COPYING
%{_mandir}/man*/*.*
%{_bindir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}
%{python3_sitelibdir_noarch}/lshell/
%{python3_sitelibdir_noarch}/%{name}*.egg-info

%changelog
