Group: Sound
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global pkgname zyn

Summary:	LV2 port of the ZynAddSubFX engine
Name:		lv2-zynadd-plugins
Version:	1
Release:	alt2_33
# lv2-midi*.h is LGPLv2+
# but the rest is GPLv2. The whole plugin will be then:
License:	GPL-2.0-only
URL:		http://home.gna.org/zyn/
Source:		http://download.gna.org/%{pkgname}/%{pkgname}-%{version}.tar.bz2

BuildRequires:	libfftw3-devel
BuildRequires:	gcc-c++
BuildRequires:	lv2-devel
BuildRequires:	lv2dynparam-devel
Requires:	lv2
Provides:	%{pkgname} = %{version}-%{release}
Source44: import.info

%description
The zyn project main goal is to extract synth engines from ZynAddSubFX and pack
them in LV2 plugin format. Resulting plugins are heavily based on work made by
Nasca Octavian Paul. If you like the amazing sounds these plugins generate you
should thank Paul for this.

%prep
%setup -q -n %{pkgname}-%{version}

# Don't hide anything
sed -i 's|\t@|\t|' GNUmakefile

# lv2core seemingly permanently renamed to lv2 at version 1.16
sed -i s/lv2core/lv2/g GNUmakefile
find . -type f -name '*.c' | xargs sed -i "s/lv2dynparam\//lv2dynparam1\/lv2dynparam\//g"

%build
%make_build \
	CFLAGS="%{optflags} -fPIC -DPIC \
	$(pkg-config --cflags fftw3 lv2core lv2dynparamplugin1)" \
	CXXFLAGS="%{optflags}" \
	LDFLAGS="%{optflags}"

%install
mkdir -p %{buildroot}%{_libdir}/lv2
make LV2_INSTALL_PATH=%{buildroot}%{_libdir}/lv2 install

%files
%doc AUTHORS README
%doc --no-dereference gpl.txt
%{_libdir}/lv2/zynadd.lv2/

%changelog
