Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dot libncurses-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: maloc
Version: 1.5
Release: alt2_30
License: GPLv2+
URL: http://www.fetk.org
Summary: Minimal Abstraction Layer for Object-oriented C
Source0: http://www.fetk.org/codes/download/%{name}-%{version}.tar.gz

BuildRequires: gcc
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: doxygen
BuildRequires: libtool
BuildRequires: libreadline-devel

# removes hardcoded libdir setting
Patch0: maloc-makefile.am.patch
Source44: import.info

%description
MALOC is a small, portable, abstract C environment library for
object-oriented C programming. MALOC is used as the foundation layer
for a number of scientific applications, including MC, SG, and
APBS. MALOC can be used as a small stand-alone abstraction environment
for writing portable C programs which need access to resources which
are typically architecture-dependent, such as INET sockets, timing
routines, and so on. MALOC provides abstract datatypes, memory
management routines, timing routines, machine epsilon, access to UNIX
and INET sockets, MPI, and so on. All things that can vary from one
architecture to another are abstracted out of an application code and
placed in MALOC.

%package devel
Group: Development/Other
Summary: Header files and library for developing programs with maloc
Requires: %{name} = %{version}-%{release}

%description devel

This package contains libraries and header files needed for program
development using MALOC.

%prep
%setup -q -n %{name}
%patch0


aclocal
libtoolize --automake
autoconf
automake --gnu --add-missing
autoheader

%build
%configure --disable-static
%make_build

make maloc_doc -C doc/doxygen

%install
%makeinstall_std

# remove unpackaged files from the buildroot
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%files
%{_libdir}/*.so.1
%{_libdir}/*.so.1.0.0

%files devel
%doc doc/api/html/*
%{_libdir}/*.so
%{_includedir}/maloc/

%changelog
