# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define LNG da

Summary:        Danish man pages from the Linux Documentation Project
Name:           man-pages-%LNG
Version:        0.1.2
Release:        alt1_7
License:        Distributable
Group:          System/Internationalization
URL:            http://www.sslug.dk/locale/man-sider/
Source0:        http://www.sslug.dk/locale/man-sider/manpages-da-%{version}.tar.gz
Patch0:         manpages-da-0.1.2-mga-makefile-paths.patch

BuildRequires:  sed
BuildRequires:  grep
BuildRequires:  man
Requires:       locales-%LNG
Requires:       man
AutoReq:        no
BuildArch:      noarch
Source44: import.info

%description
A large collection of man pages (reference material) from the Linux
Documentation Project (LDP), translated to Danish.  The man pages are
organized into the following sections:

        Section 1:  User commands (intro only)
        Section 2:  System calls
        Section 3:  Libc calls
        Section 4:  Devices (e.g., hd, sd)
        Section 5:  File formats and protocols (e.g., wtmp, %{_sysconfdir}/passwd,
                    nfs)
        Section 6:  Games (intro only)
        Section 7:  Conventions, macro packages, etc. (e.g., nroff, ascii)
        Section 8:  System administration (intro only)

%prep
%setup -q -n manpages-da-%{version}

# Fix encoding
for file in *; do
  iconv -f ISO-8859-1 -t UTF-8 $file > $file.new
  touch -r $file $file.new
  mv $file.new $file
done
mv l?smig læsmig

%patch0 -p1


%build

%install
%makeinstall_std PREFIX=%{buildroot}%{_prefix}

%postun
if [ "$1" = "0" ]; then
   ## Force removing of /var/catman/%%{LNG}, if there isn't any man page
   ## directory /%%{_mandir}/%%{LNG}
   if [ ! -d %{_mandir}/%{LNG} ] ; then
       /bin/rm -rf /var/catman/%{LNG}
   fi
fi

%files
%doc læsmig AUTHORS ChangeLog
%{_mandir}/%{LNG}/


%changelog
