Group: Other
%set_compress_method none
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Korean(Hangul) Man(manual) Pages from the Korean Manpage Project
Name: man-pages-ko
Version: 20050219
Release: alt1_46
# The Copyright only license is from the old spec file,
# The other licenses are the result from the scancode toolkit.
License: Copyright only AND Apache-1.0 AND BSD-3-Clause AND BSD-4-Clause-UC AND GPL-1.0-or-later AND GPL-2.0-only AND GPL-2.0-or-later AND Linux-man-pages-copyleft AND X11
Epoch: 2
#Vendor: Korean Manpage Project Team.
URL: http://man.kldp.org/
Source0: http://kldp.net/frs/download.php/1918/%{name}-%{version}.tar.gz
# The original version of the copyright text is on the upstream wiki:
# http://man.kldp.org/wiki/ManPageCopyright
Source1: Man_Page_Copyright
# Patch for utf-8 conversion (original patch includes euc-kr and iso-8859-1)
Patch0: %{name}-%{version}.patch
BuildArch: noarch
Summary(ko): 한글 Manpage 프로젝트에 의한 한글 Manpage 
Requires: man-pages-reader
Source44: import.info

%description
Korean translation of the official manpages from LDP and
another useful manpages from various packages. It's done
by the Korean Manpage Project <http://man.kldp.org> which
is maintained by Korean Manpage Project Team.

%description -l ko
한글 Manpage 프로젝트에서 비롯된 한글 Manpages.
이는 한글 Manpage 프로젝트 팀이 관리하는 한글 Manpage
프로젝트 <http://man.kldp.org>에 의한 것입니다.

%prep
%setup -q -c %{name}-%{version}
%patch0 -p0
find . -name CVS -exec rm -rf {} \;
cp -p %{SOURCE1} COPYING

#conflict with man
rm -f ./man1/man.1 ./man1/whatis.1 ./man5/man.config.5 
#conflict with shadow-utils in Fedora 9
rm -f ./man8/vipw.8
#conflict with rpms in Fedora 9
rm -f ./man8/rpm.8 ./man8/rpm2cpio.8
# Bug 468501
rm -f ./man1/cpio.1
# Non-free man-pages (bz1334290)
rm man2/sysinfo.2
rm man2/getitimer.2
#conflict with psmisc
rm man1/killall.1

%build 
for i in man?; do
    for j in $i/*; do
        case "$j" in
            man7/iso_8859-1.7 | man7/iso_8859-7.7)
                ;;
            *)
                iconv -f EUC-KR -t UTF-8 $j -o $j.out
                touch -r $j $j.out
                mv $j.out $j
                ;;
        esac
    done
done


%install
mkdir -p $RPM_BUILD_ROOT%{_mandir}/ko
cp -a man? $RPM_BUILD_ROOT%{_mandir}/ko/

%files
%doc --no-dereference COPYING
%{_mandir}/ko/man*/*

%changelog
