Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/curl-config /usr/bin/pkg-config /usr/bin/sdl-config /usr/bin/sdl2-config gcc-c++ libGL-devel libSDL-devel libSDL2-devel libSDL2_image-devel libSDL2_mixer-devel libSDL2_net-devel libSDL2_ttf-devel libX11-devel libxml2-devel zlib-devel
# END SourceDeps(oneline)
Name:           manaplus
Version:        1.3.10.27.2
Release:        alt3_8
Summary:        OpenSource 2D MMORPG client for Evol Online and The Mana World
License:        GPLv2+
Url:            http://manaplus.evolonline.org/
Source0:        http://download.evolonline.org/manaplus/download/%{version}/%{name}-%{version}.tar.xz
Requires:       fonts-ttf-dejavu
Requires:       fonts-ttf-dejavu
Requires:       fonts-ttf-dejavu
Requires:       fonts-ttf-liberation
Requires:       fonts-ttf-liberation
Requires:       fonts-ttf-mplus-1p
Requires:       xdg-utils
Requires:       xorg-utils
Requires:       xsel
BuildRequires:  desktop-file-utils
BuildRequires:  gettext
BuildRequires:  libguichan-devel
BuildRequires:  libcurl-devel
BuildRequires:  libpng-devel
BuildRequires:  libphysfs-devel
BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  libSDL_gfx-devel
BuildRequires:  libSDL_image-devel
BuildRequires:  libSDL_mixer-devel
BuildRequires:  libSDL_net-devel
BuildRequires:  libSDL_ttf-devel
Obsoletes:      mana < 0.6.1-8
Source44: import.info

%description
ManaPlus is an extended client for Evol Online, The Mana World, and similar
servers based on a fork of eAthena. Evol Online is a 2D fantasy-style game
which aims to create a friendly environment for interacting with others where
people can escape reality and enjoy themselves. The Mana World (TMW) is a
serious effort to create an innovative free and open source MMORPG.
TMW uses 2D graphics and aims to create a large and diverse interactive world.

%prep
# 1.3.10.27.2 did not change the version in the archive extract
%setup -q -n manaplus-1.3.10.27

# We will build without bundeled guichan. To make sure it will be removed.
rm -rf src/guichan

%build
%configure --without-internalguichan

make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}
desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}.desktop
desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}test.desktop

# Use system fonts
rm -f %{buildroot}%{_datadir}/%{name}/data/fonts/*.ttf
ln -s %{_datadir}/fonts/ttf/dejavu/DejaVuSans-Bold.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/dejavusans-bold.ttf
ln -s %{_datadir}/fonts/ttf/dejavu/DejaVuSansMono-Bold.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/dejavusansmono-bold.ttf
ln -s %{_datadir}/fonts/ttf/dejavu/DejaVuSansMono.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/dejavusansmono.ttf
ln -s %{_datadir}/fonts/ttf/dejavu/DejaVuSerifCondensed-Bold.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/dejavuserifcondensed-bold.ttf
ln -s %{_datadir}/fonts/ttf/dejavu/DejaVuSerifCondensed.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/dejavuserifcondensed.ttf
ln -s %{_datadir}/fonts/ttf/dejavu/DejaVuSans.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/dejavusans.ttf
ln -s %{_datadir}/fonts/ttf/liberation/LiberationMono-Bold.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/liberationsansmono-bold.ttf
ln -s %{_datadir}/fonts/ttf/liberation/LiberationMono-Regular.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/liberationsansmono.ttf
ln -s %{_datadir}/fonts/ttf/liberation/LiberationSans-Bold.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/liberationsans-bold.ttf
ln -s %{_datadir}/fonts/ttf/liberation/LiberationSans-Regular.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/liberationsans.ttf
ln -s %{_datadir}/fonts/ttf/mplus/mplus-1p-bold.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/mplus-1p-bold.ttf
ln -s %{_datadir}/fonts/ttf/mplus/mplus-1p-regular.ttf %{buildroot}%{_datadir}/%{name}/data/fonts/mplus-1p-regular.ttf

# Register as an application to be visible in the software center
#
# NOTE: It would be *awesome* if this file was maintained by the upstream
# project, translated and installed into the right place during `make install`.
#
# See http://www.freedesktop.org/software/appstream/docs/ for more details.
#
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
cat > $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2014 Edgar Muniz Berlinck <edgar.vv@gmail.com> -->
<!--
BugReportURL: https://github.com/themanaworld/tmwa-client-data/issues/104
SentUpstream: 2014-09-24
-->
<application>
  <id type="desktop">manaplus.desktop</id>
  <metadata_license>CC0-1.0</metadata_license>
  <summary>2D Adventure MMORPG</summary>
  <description>
    <p>
      Free 2D MMORPG.
      You can choose to join a Guild, become stronger and travel new lands as one
      adventurer or live in peace with your friends.
    </p>
  </description>
  <url type="homepage">http://manaplus.org/</url>
  <screenshots>
    <screenshot type="default">http://manaplus.org/_media/manaplus_screenshot_8.png</screenshot>
    <screenshot>http://manaplus.org/_media/manaplus_screenshot_11.png</screenshot>
    <screenshot>http://manaplus.org/_media/manaplus_screenshot_15.png</screenshot>
  </screenshots>
</application>
EOF

%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS ChangeLog COPYING docs/FAQ.txt README
%{_bindir}/%{name}
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/applications/%{name}test.desktop
%{_datadir}/%{name}
%{_datadir}/pixmaps/%{name}.png
%{_mandir}/man6/%{name}.6*
%{_mandir}/man6/%{name}test.6*

%changelog
